/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ServiceStatus;
import io.fabric8.kubernetes.api.model.ServiceStatusFluent;
import io.fabric8.kubernetes.api.model.ServiceStatusFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ServiceStatusBuilder
extends ServiceStatusFluentImpl<ServiceStatusBuilder>
implements VisitableBuilder<ServiceStatus, ServiceStatusBuilder> {
    ServiceStatusFluent<?> fluent;

    public ServiceStatusBuilder() {
        this(new ServiceStatus());
    }

    public ServiceStatusBuilder(ServiceStatusFluent<?> fluent) {
        this(fluent, new ServiceStatus());
    }

    public ServiceStatusBuilder(ServiceStatusFluent<?> fluent, ServiceStatus instance) {
        this.fluent = fluent;
        fluent.withLoadBalancer(instance.getLoadBalancer());
    }

    public ServiceStatusBuilder(ServiceStatus instance) {
        this.fluent = this;
        this.withLoadBalancer(instance.getLoadBalancer());
    }

    @Override
    public ServiceStatus build() {
        ServiceStatus buildable = new ServiceStatus(this.fluent.getLoadBalancer());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceStatusBuilder that = (ServiceStatusBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

