/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LoadBalancerStatus;
import io.fabric8.kubernetes.api.model.LoadBalancerStatusBuilder;
import io.fabric8.kubernetes.api.model.LoadBalancerStatusFluentImpl;
import io.fabric8.kubernetes.api.model.ServiceStatus;
import io.fabric8.kubernetes.api.model.ServiceStatusFluent;

public class ServiceStatusFluentImpl<A extends ServiceStatusFluent<A>>
extends BaseFluent<A>
implements ServiceStatusFluent<A> {
    VisitableBuilder<LoadBalancerStatus, ?> loadBalancer;

    public ServiceStatusFluentImpl() {
    }

    public ServiceStatusFluentImpl(ServiceStatus instance) {
        this.withLoadBalancer(instance.getLoadBalancer());
    }

    @Override
    public LoadBalancerStatus getLoadBalancer() {
        return this.loadBalancer != null ? (LoadBalancerStatus)this.loadBalancer.build() : null;
    }

    @Override
    public A withLoadBalancer(LoadBalancerStatus loadBalancer) {
        if (loadBalancer != null) {
            this.loadBalancer = new LoadBalancerStatusBuilder(loadBalancer);
            this._visitables.add(this.loadBalancer);
        }
        return (A)this;
    }

    @Override
    public ServiceStatusFluent.LoadBalancerNested<A> withNewLoadBalancer() {
        return new LoadBalancerNestedImpl();
    }

    @Override
    public ServiceStatusFluent.LoadBalancerNested<A> withNewLoadBalancerLike(LoadBalancerStatus item) {
        return new LoadBalancerNestedImpl(item);
    }

    @Override
    public ServiceStatusFluent.LoadBalancerNested<A> editLoadBalancer() {
        return this.withNewLoadBalancerLike(this.getLoadBalancer());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceStatusFluentImpl that = (ServiceStatusFluentImpl)o;
        return !(this.loadBalancer != null ? !this.loadBalancer.equals(that.loadBalancer) : that.loadBalancer != null);
    }

    public class LoadBalancerNestedImpl<N>
    extends LoadBalancerStatusFluentImpl<ServiceStatusFluent.LoadBalancerNested<N>>
    implements ServiceStatusFluent.LoadBalancerNested<N> {
        private final LoadBalancerStatusBuilder builder;

        LoadBalancerNestedImpl() {
            this.builder = new LoadBalancerStatusBuilder(this);
        }

        LoadBalancerNestedImpl(LoadBalancerStatus item) {
            this.builder = new LoadBalancerStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ServiceStatusFluentImpl.this.withLoadBalancer(this.builder.build());
        }

        @Override
        public N endLoadBalancer() {
            return this.and();
        }
    }
}

