/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.StatusFluent;
import io.fabric8.kubernetes.api.model.StatusFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class StatusBuilder
extends StatusFluentImpl<StatusBuilder>
implements VisitableBuilder<Status, StatusBuilder> {
    StatusFluent<?> fluent;

    public StatusBuilder() {
        this(new Status());
    }

    public StatusBuilder(StatusFluent<?> fluent) {
        this(fluent, new Status());
    }

    public StatusBuilder(StatusFluent<?> fluent, Status instance) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withCode(instance.getCode());
        fluent.withDetails(instance.getDetails());
        fluent.withKind(instance.getKind());
        fluent.withMessage(instance.getMessage());
        fluent.withMetadata(instance.getMetadata());
        fluent.withReason(instance.getReason());
        fluent.withStatus(instance.getStatus());
    }

    public StatusBuilder(Status instance) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withCode(instance.getCode());
        this.withDetails(instance.getDetails());
        this.withKind(instance.getKind());
        this.withMessage(instance.getMessage());
        this.withMetadata(instance.getMetadata());
        this.withReason(instance.getReason());
        this.withStatus(instance.getStatus());
    }

    @Override
    public Status build() {
        Status buildable = new Status(this.fluent.getApiVersion(), this.fluent.getCode(), this.fluent.getDetails(), this.fluent.getKind(), this.fluent.getMessage(), this.fluent.getMetadata(), this.fluent.getReason(), this.fluent.getStatus());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatusBuilder that = (StatusBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

