/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountFluent;
import io.fabric8.kubernetes.api.model.VolumeMountFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class VolumeMountBuilder
extends VolumeMountFluentImpl<VolumeMountBuilder>
implements VisitableBuilder<VolumeMount, VolumeMountBuilder> {
    VolumeMountFluent<?> fluent;

    public VolumeMountBuilder() {
        this(new VolumeMount());
    }

    public VolumeMountBuilder(VolumeMountFluent<?> fluent) {
        this(fluent, new VolumeMount());
    }

    public VolumeMountBuilder(VolumeMountFluent<?> fluent, VolumeMount instance) {
        this.fluent = fluent;
        fluent.withMountPath(instance.getMountPath());
        fluent.withName(instance.getName());
        fluent.withReadOnly(instance.getReadOnly());
    }

    public VolumeMountBuilder(VolumeMount instance) {
        this.fluent = this;
        this.withMountPath(instance.getMountPath());
        this.withName(instance.getName());
        this.withReadOnly(instance.getReadOnly());
    }

    @Override
    public VolumeMount build() {
        VolumeMount buildable = new VolumeMount(this.fluent.getMountPath(), this.fluent.getName(), this.fluent.isReadOnly());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VolumeMountBuilder that = (VolumeMountBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

