/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.DaemonSet;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetFluent;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetSpec;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecBuilder;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetStatus;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetStatusBuilder;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetStatusFluentImpl;

public class DaemonSetFluentImpl<A extends DaemonSetFluent<A>>
extends BaseFluent<A>
implements DaemonSetFluent<A> {
    String apiVersion;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<DaemonSetSpec, ?> spec;
    VisitableBuilder<DaemonSetStatus, ?> status;

    public DaemonSetFluentImpl() {
    }

    public DaemonSetFluentImpl(DaemonSet instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public DaemonSetFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public DaemonSetFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public DaemonSetFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public DaemonSetSpec getSpec() {
        return this.spec != null ? (DaemonSetSpec)this.spec.build() : null;
    }

    @Override
    public A withSpec(DaemonSetSpec spec) {
        if (spec != null) {
            this.spec = new DaemonSetSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (A)this;
    }

    @Override
    public DaemonSetFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public DaemonSetFluent.SpecNested<A> withNewSpecLike(DaemonSetSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public DaemonSetFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public DaemonSetStatus getStatus() {
        return this.status != null ? (DaemonSetStatus)this.status.build() : null;
    }

    @Override
    public A withStatus(DaemonSetStatus status) {
        if (status != null) {
            this.status = new DaemonSetStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (A)this;
    }

    @Override
    public DaemonSetFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public DaemonSetFluent.StatusNested<A> withNewStatusLike(DaemonSetStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public DaemonSetFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public A withNewStatus(Integer currentNumberScheduled, Integer desiredNumberScheduled, Integer numberMisscheduled) {
        return this.withStatus(new DaemonSetStatus(currentNumberScheduled, desiredNumberScheduled, numberMisscheduled));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DaemonSetFluentImpl that = (DaemonSetFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public class StatusNestedImpl<N>
    extends DaemonSetStatusFluentImpl<DaemonSetFluent.StatusNested<N>>
    implements DaemonSetFluent.StatusNested<N> {
        private final DaemonSetStatusBuilder builder;

        StatusNestedImpl() {
            this.builder = new DaemonSetStatusBuilder(this);
        }

        StatusNestedImpl(DaemonSetStatus item) {
            this.builder = new DaemonSetStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DaemonSetFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends DaemonSetSpecFluentImpl<DaemonSetFluent.SpecNested<N>>
    implements DaemonSetFluent.SpecNested<N> {
        private final DaemonSetSpecBuilder builder;

        SpecNestedImpl() {
            this.builder = new DaemonSetSpecBuilder(this);
        }

        SpecNestedImpl(DaemonSetSpec item) {
            this.builder = new DaemonSetSpecBuilder(this, item);
        }

        @Override
        public N endSpec() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)DaemonSetFluentImpl.this.withSpec(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<DaemonSetFluent.MetadataNested<N>>
    implements DaemonSetFluent.MetadataNested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)DaemonSetFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

