/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathFluent;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class HTTPIngressPathBuilder
extends HTTPIngressPathFluentImpl<HTTPIngressPathBuilder>
implements VisitableBuilder<HTTPIngressPath, HTTPIngressPathBuilder> {
    HTTPIngressPathFluent<?> fluent;

    public HTTPIngressPathBuilder() {
        this(new HTTPIngressPath());
    }

    public HTTPIngressPathBuilder(HTTPIngressPathFluent<?> fluent) {
        this(fluent, new HTTPIngressPath());
    }

    public HTTPIngressPathBuilder(HTTPIngressPathFluent<?> fluent, HTTPIngressPath instance) {
        this.fluent = fluent;
        fluent.withBackend(instance.getBackend());
        fluent.withPath(instance.getPath());
    }

    public HTTPIngressPathBuilder(HTTPIngressPath instance) {
        this.fluent = this;
        this.withBackend(instance.getBackend());
        this.withPath(instance.getPath());
    }

    @Override
    public HTTPIngressPath build() {
        HTTPIngressPath buildable = new HTTPIngressPath(this.fluent.getBackend(), this.fluent.getPath());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPIngressPathBuilder that = (HTTPIngressPathBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

