/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.CPUTargetUtilization;
import io.fabric8.kubernetes.api.model.extensions.CPUTargetUtilizationBuilder;
import io.fabric8.kubernetes.api.model.extensions.CPUTargetUtilizationFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerSpec;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.SubresourceReference;
import io.fabric8.kubernetes.api.model.extensions.SubresourceReferenceBuilder;
import io.fabric8.kubernetes.api.model.extensions.SubresourceReferenceFluentImpl;

public class HorizontalPodAutoscalerSpecFluentImpl<A extends HorizontalPodAutoscalerSpecFluent<A>>
extends BaseFluent<A>
implements HorizontalPodAutoscalerSpecFluent<A> {
    VisitableBuilder<CPUTargetUtilization, ?> cpuUtilization;
    Integer maxReplicas;
    Integer minReplicas;
    VisitableBuilder<SubresourceReference, ?> scaleRef;

    public HorizontalPodAutoscalerSpecFluentImpl() {
    }

    public HorizontalPodAutoscalerSpecFluentImpl(HorizontalPodAutoscalerSpec instance) {
        this.withCpuUtilization(instance.getCpuUtilization());
        this.withMaxReplicas(instance.getMaxReplicas());
        this.withMinReplicas(instance.getMinReplicas());
        this.withScaleRef(instance.getScaleRef());
    }

    @Override
    public CPUTargetUtilization getCpuUtilization() {
        return this.cpuUtilization != null ? (CPUTargetUtilization)this.cpuUtilization.build() : null;
    }

    @Override
    public A withCpuUtilization(CPUTargetUtilization cpuUtilization) {
        if (cpuUtilization != null) {
            this.cpuUtilization = new CPUTargetUtilizationBuilder(cpuUtilization);
            this._visitables.add(this.cpuUtilization);
        }
        return (A)this;
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.CpuUtilizationNested<A> withNewCpuUtilization() {
        return new CpuUtilizationNestedImpl();
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.CpuUtilizationNested<A> withNewCpuUtilizationLike(CPUTargetUtilization item) {
        return new CpuUtilizationNestedImpl(item);
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.CpuUtilizationNested<A> editCpuUtilization() {
        return this.withNewCpuUtilizationLike(this.getCpuUtilization());
    }

    @Override
    public A withNewCpuUtilization(Integer targetPercentage) {
        return this.withCpuUtilization(new CPUTargetUtilization(targetPercentage));
    }

    @Override
    public Integer getMaxReplicas() {
        return this.maxReplicas;
    }

    @Override
    public A withMaxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
        return (A)this;
    }

    @Override
    public Integer getMinReplicas() {
        return this.minReplicas;
    }

    @Override
    public A withMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
        return (A)this;
    }

    @Override
    public SubresourceReference getScaleRef() {
        return this.scaleRef != null ? (SubresourceReference)this.scaleRef.build() : null;
    }

    @Override
    public A withScaleRef(SubresourceReference scaleRef) {
        if (scaleRef != null) {
            this.scaleRef = new SubresourceReferenceBuilder(scaleRef);
            this._visitables.add(this.scaleRef);
        }
        return (A)this;
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.ScaleRefNested<A> withNewScaleRef() {
        return new ScaleRefNestedImpl();
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.ScaleRefNested<A> withNewScaleRefLike(SubresourceReference item) {
        return new ScaleRefNestedImpl(item);
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.ScaleRefNested<A> editScaleRef() {
        return this.withNewScaleRefLike(this.getScaleRef());
    }

    @Override
    public A withNewScaleRef(String apiVersion, String kind, String name, String subresource) {
        return this.withScaleRef(new SubresourceReference(apiVersion, kind, name, subresource));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HorizontalPodAutoscalerSpecFluentImpl that = (HorizontalPodAutoscalerSpecFluentImpl)o;
        if (this.cpuUtilization != null ? !this.cpuUtilization.equals(that.cpuUtilization) : that.cpuUtilization != null) {
            return false;
        }
        if (this.maxReplicas != null ? !this.maxReplicas.equals(that.maxReplicas) : that.maxReplicas != null) {
            return false;
        }
        if (this.minReplicas != null ? !this.minReplicas.equals(that.minReplicas) : that.minReplicas != null) {
            return false;
        }
        return !(this.scaleRef != null ? !this.scaleRef.equals(that.scaleRef) : that.scaleRef != null);
    }

    public class ScaleRefNestedImpl<N>
    extends SubresourceReferenceFluentImpl<HorizontalPodAutoscalerSpecFluent.ScaleRefNested<N>>
    implements HorizontalPodAutoscalerSpecFluent.ScaleRefNested<N> {
        private final SubresourceReferenceBuilder builder;

        ScaleRefNestedImpl() {
            this.builder = new SubresourceReferenceBuilder(this);
        }

        ScaleRefNestedImpl(SubresourceReference item) {
            this.builder = new SubresourceReferenceBuilder(this, item);
        }

        @Override
        public N endScaleRef() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)HorizontalPodAutoscalerSpecFluentImpl.this.withScaleRef(this.builder.build());
        }
    }

    public class CpuUtilizationNestedImpl<N>
    extends CPUTargetUtilizationFluentImpl<HorizontalPodAutoscalerSpecFluent.CpuUtilizationNested<N>>
    implements HorizontalPodAutoscalerSpecFluent.CpuUtilizationNested<N> {
        private final CPUTargetUtilizationBuilder builder;

        CpuUtilizationNestedImpl() {
            this.builder = new CPUTargetUtilizationBuilder(this);
        }

        CpuUtilizationNestedImpl(CPUTargetUtilization item) {
            this.builder = new CPUTargetUtilizationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HorizontalPodAutoscalerSpecFluentImpl.this.withCpuUtilization(this.builder.build());
        }

        @Override
        public N endCpuUtilization() {
            return this.and();
        }
    }
}

