/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerStatus;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerStatusFluent;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerStatusFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class HorizontalPodAutoscalerStatusBuilder
extends HorizontalPodAutoscalerStatusFluentImpl<HorizontalPodAutoscalerStatusBuilder>
implements VisitableBuilder<HorizontalPodAutoscalerStatus, HorizontalPodAutoscalerStatusBuilder> {
    HorizontalPodAutoscalerStatusFluent<?> fluent;

    public HorizontalPodAutoscalerStatusBuilder() {
        this(new HorizontalPodAutoscalerStatus());
    }

    public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatusFluent<?> fluent) {
        this(fluent, new HorizontalPodAutoscalerStatus());
    }

    public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatusFluent<?> fluent, HorizontalPodAutoscalerStatus instance) {
        this.fluent = fluent;
        fluent.withCurrentCPUUtilizationPercentage(instance.getCurrentCPUUtilizationPercentage());
        fluent.withCurrentReplicas(instance.getCurrentReplicas());
        fluent.withDesiredReplicas(instance.getDesiredReplicas());
        fluent.withLastScaleTime(instance.getLastScaleTime());
        fluent.withObservedGeneration(instance.getObservedGeneration());
    }

    public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatus instance) {
        this.fluent = this;
        this.withCurrentCPUUtilizationPercentage(instance.getCurrentCPUUtilizationPercentage());
        this.withCurrentReplicas(instance.getCurrentReplicas());
        this.withDesiredReplicas(instance.getDesiredReplicas());
        this.withLastScaleTime(instance.getLastScaleTime());
        this.withObservedGeneration(instance.getObservedGeneration());
    }

    @Override
    public HorizontalPodAutoscalerStatus build() {
        HorizontalPodAutoscalerStatus buildable = new HorizontalPodAutoscalerStatus(this.fluent.getCurrentCPUUtilizationPercentage(), this.fluent.getCurrentReplicas(), this.fluent.getDesiredReplicas(), this.fluent.getLastScaleTime(), this.fluent.getObservedGeneration());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HorizontalPodAutoscalerStatusBuilder that = (HorizontalPodAutoscalerStatusBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

