/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressBackend;
import io.fabric8.kubernetes.api.model.extensions.IngressBackendFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressBackendFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class IngressBackendBuilder
extends IngressBackendFluentImpl<IngressBackendBuilder>
implements VisitableBuilder<IngressBackend, IngressBackendBuilder> {
    IngressBackendFluent<?> fluent;

    public IngressBackendBuilder() {
        this(new IngressBackend());
    }

    public IngressBackendBuilder(IngressBackendFluent<?> fluent) {
        this(fluent, new IngressBackend());
    }

    public IngressBackendBuilder(IngressBackendFluent<?> fluent, IngressBackend instance) {
        this.fluent = fluent;
        fluent.withServiceName(instance.getServiceName());
        fluent.withServicePort(instance.getServicePort());
    }

    public IngressBackendBuilder(IngressBackend instance) {
        this.fluent = this;
        this.withServiceName(instance.getServiceName());
        this.withServicePort(instance.getServicePort());
    }

    @Override
    public IngressBackend build() {
        IngressBackend buildable = new IngressBackend(this.fluent.getServiceName(), this.fluent.getServicePort());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressBackendBuilder that = (IngressBackendBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

