/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressRule;
import io.fabric8.kubernetes.api.model.extensions.IngressRuleFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressRuleFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class IngressRuleBuilder
extends IngressRuleFluentImpl<IngressRuleBuilder>
implements VisitableBuilder<IngressRule, IngressRuleBuilder> {
    IngressRuleFluent<?> fluent;

    public IngressRuleBuilder() {
        this(new IngressRule());
    }

    public IngressRuleBuilder(IngressRuleFluent<?> fluent) {
        this(fluent, new IngressRule());
    }

    public IngressRuleBuilder(IngressRuleFluent<?> fluent, IngressRule instance) {
        this.fluent = fluent;
        fluent.withHost(instance.getHost());
        fluent.withHttp(instance.getHttp());
    }

    public IngressRuleBuilder(IngressRule instance) {
        this.fluent = this;
        this.withHost(instance.getHost());
        this.withHttp(instance.getHttp());
    }

    @Override
    public IngressRule build() {
        IngressRule buildable = new IngressRule(this.fluent.getHost(), this.fluent.getHttp());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressRuleBuilder that = (IngressRuleBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

