/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressStatus;
import io.fabric8.kubernetes.api.model.extensions.IngressStatusFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressStatusFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class IngressStatusBuilder
extends IngressStatusFluentImpl<IngressStatusBuilder>
implements VisitableBuilder<IngressStatus, IngressStatusBuilder> {
    IngressStatusFluent<?> fluent;

    public IngressStatusBuilder() {
        this(new IngressStatus());
    }

    public IngressStatusBuilder(IngressStatusFluent<?> fluent) {
        this(fluent, new IngressStatus());
    }

    public IngressStatusBuilder(IngressStatusFluent<?> fluent, IngressStatus instance) {
        this.fluent = fluent;
        fluent.withLoadBalancer(instance.getLoadBalancer());
    }

    public IngressStatusBuilder(IngressStatus instance) {
        this.fluent = this;
        this.withLoadBalancer(instance.getLoadBalancer());
    }

    @Override
    public IngressStatus build() {
        IngressStatus buildable = new IngressStatus(this.fluent.getLoadBalancer());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressStatusBuilder that = (IngressStatusBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

