/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressTLS;
import io.fabric8.kubernetes.api.model.extensions.IngressTLSFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressTLSFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class IngressTLSBuilder
extends IngressTLSFluentImpl<IngressTLSBuilder>
implements VisitableBuilder<IngressTLS, IngressTLSBuilder> {
    IngressTLSFluent<?> fluent;

    public IngressTLSBuilder() {
        this(new IngressTLS());
    }

    public IngressTLSBuilder(IngressTLSFluent<?> fluent) {
        this(fluent, new IngressTLS());
    }

    public IngressTLSBuilder(IngressTLSFluent<?> fluent, IngressTLS instance) {
        this.fluent = fluent;
        fluent.withHosts(instance.getHosts());
        fluent.withSecretName(instance.getSecretName());
    }

    public IngressTLSBuilder(IngressTLS instance) {
        this.fluent = this;
        this.withHosts(instance.getHosts());
        this.withSecretName(instance.getSecretName());
    }

    @Override
    public IngressTLS build() {
        IngressTLS buildable = new IngressTLS(this.fluent.getHosts(), this.fluent.getSecretName());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressTLSBuilder that = (IngressTLSBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

