/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.JobCondition;
import io.fabric8.kubernetes.api.model.extensions.JobConditionFluent;
import io.fabric8.kubernetes.api.model.extensions.JobConditionFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class JobConditionBuilder
extends JobConditionFluentImpl<JobConditionBuilder>
implements VisitableBuilder<JobCondition, JobConditionBuilder> {
    JobConditionFluent<?> fluent;

    public JobConditionBuilder() {
        this(new JobCondition());
    }

    public JobConditionBuilder(JobConditionFluent<?> fluent) {
        this(fluent, new JobCondition());
    }

    public JobConditionBuilder(JobConditionFluent<?> fluent, JobCondition instance) {
        this.fluent = fluent;
        fluent.withLastProbeTime(instance.getLastProbeTime());
        fluent.withLastTransitionTime(instance.getLastTransitionTime());
        fluent.withMessage(instance.getMessage());
        fluent.withReason(instance.getReason());
        fluent.withStatus(instance.getStatus());
        fluent.withType(instance.getType());
    }

    public JobConditionBuilder(JobCondition instance) {
        this.fluent = this;
        this.withLastProbeTime(instance.getLastProbeTime());
        this.withLastTransitionTime(instance.getLastTransitionTime());
        this.withMessage(instance.getMessage());
        this.withReason(instance.getReason());
        this.withStatus(instance.getStatus());
        this.withType(instance.getType());
    }

    @Override
    public JobCondition build() {
        JobCondition buildable = new JobCondition(this.fluent.getLastProbeTime(), this.fluent.getLastTransitionTime(), this.fluent.getMessage(), this.fluent.getReason(), this.fluent.getStatus(), this.fluent.getType());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JobConditionBuilder that = (JobConditionBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

