/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.JobSpec;
import io.fabric8.kubernetes.api.model.extensions.JobSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.JobSpecFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class JobSpecBuilder
extends JobSpecFluentImpl<JobSpecBuilder>
implements VisitableBuilder<JobSpec, JobSpecBuilder> {
    JobSpecFluent<?> fluent;

    public JobSpecBuilder() {
        this(new JobSpec());
    }

    public JobSpecBuilder(JobSpecFluent<?> fluent) {
        this(fluent, new JobSpec());
    }

    public JobSpecBuilder(JobSpecFluent<?> fluent, JobSpec instance) {
        this.fluent = fluent;
        fluent.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
        fluent.withAutoSelector(instance.getAutoSelector());
        fluent.withCompletions(instance.getCompletions());
        fluent.withParallelism(instance.getParallelism());
        fluent.withSelector(instance.getSelector());
        fluent.withTemplate(instance.getTemplate());
    }

    public JobSpecBuilder(JobSpec instance) {
        this.fluent = this;
        this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
        this.withAutoSelector(instance.getAutoSelector());
        this.withCompletions(instance.getCompletions());
        this.withParallelism(instance.getParallelism());
        this.withSelector(instance.getSelector());
        this.withTemplate(instance.getTemplate());
    }

    @Override
    public JobSpec build() {
        JobSpec buildable = new JobSpec(this.fluent.getActiveDeadlineSeconds(), this.fluent.isAutoSelector(), this.fluent.getCompletions(), this.fluent.getParallelism(), this.fluent.getSelector(), this.fluent.getTemplate());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JobSpecBuilder that = (JobSpecBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

