/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.JobCondition;
import io.fabric8.kubernetes.api.model.extensions.JobConditionBuilder;
import io.fabric8.kubernetes.api.model.extensions.JobConditionFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.JobStatus;
import io.fabric8.kubernetes.api.model.extensions.JobStatusFluent;
import java.util.ArrayList;
import java.util.List;

public class JobStatusFluentImpl<A extends JobStatusFluent<A>>
extends BaseFluent<A>
implements JobStatusFluent<A> {
    Integer active;
    String completionTime;
    List<VisitableBuilder<JobCondition, ?>> conditions = new ArrayList();
    Integer failed;
    String startTime;
    Integer succeeded;

    public JobStatusFluentImpl() {
    }

    public JobStatusFluentImpl(JobStatus instance) {
        this.withActive(instance.getActive());
        this.withCompletionTime(instance.getCompletionTime());
        this.withConditions(instance.getConditions());
        this.withFailed(instance.getFailed());
        this.withStartTime(instance.getStartTime());
        this.withSucceeded(instance.getSucceeded());
    }

    @Override
    public Integer getActive() {
        return this.active;
    }

    @Override
    public A withActive(Integer active) {
        this.active = active;
        return (A)this;
    }

    @Override
    public String getCompletionTime() {
        return this.completionTime;
    }

    @Override
    public A withCompletionTime(String completionTime) {
        this.completionTime = completionTime;
        return (A)this;
    }

    @Override
    public A addToConditions(JobCondition ... items) {
        for (JobCondition item : items) {
            JobConditionBuilder builder = new JobConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(JobCondition ... items) {
        for (JobCondition item : items) {
            JobConditionBuilder builder = new JobConditionBuilder(item);
            this._visitables.remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<JobCondition> getConditions() {
        return this.build(this.conditions);
    }

    @Override
    public A withConditions(List<JobCondition> conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (JobCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withConditions(JobCondition ... conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (JobCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public JobStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public JobStatusFluent.ConditionsNested<A> addNewConditionLike(JobCondition item) {
        return new ConditionsNestedImpl(item);
    }

    @Override
    public Integer getFailed() {
        return this.failed;
    }

    @Override
    public A withFailed(Integer failed) {
        this.failed = failed;
        return (A)this;
    }

    @Override
    public String getStartTime() {
        return this.startTime;
    }

    @Override
    public A withStartTime(String startTime) {
        this.startTime = startTime;
        return (A)this;
    }

    @Override
    public Integer getSucceeded() {
        return this.succeeded;
    }

    @Override
    public A withSucceeded(Integer succeeded) {
        this.succeeded = succeeded;
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobStatusFluentImpl that = (JobStatusFluentImpl)o;
        if (this.active != null ? !this.active.equals(that.active) : that.active != null) {
            return false;
        }
        if (this.completionTime != null ? !this.completionTime.equals(that.completionTime) : that.completionTime != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.failed != null ? !this.failed.equals(that.failed) : that.failed != null) {
            return false;
        }
        if (this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null) {
            return false;
        }
        return !(this.succeeded != null ? !this.succeeded.equals(that.succeeded) : that.succeeded != null);
    }

    public class ConditionsNestedImpl<N>
    extends JobConditionFluentImpl<JobStatusFluent.ConditionsNested<N>>
    implements JobStatusFluent.ConditionsNested<N> {
        private final JobConditionBuilder builder;

        ConditionsNestedImpl() {
            this.builder = new JobConditionBuilder(this);
        }

        ConditionsNestedImpl(JobCondition item) {
            this.builder = new JobConditionBuilder(this, item);
        }

        @Override
        public N endCondition() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)JobStatusFluentImpl.this.addToConditions(this.builder.build());
        }
    }
}

