/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetFluent;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpec;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpecBuilder;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpecFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetStatus;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetStatusBuilder;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetStatusFluentImpl;

public class ReplicaSetFluentImpl<A extends ReplicaSetFluent<A>>
extends BaseFluent<A>
implements ReplicaSetFluent<A> {
    String apiVersion;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<ReplicaSetSpec, ?> spec;
    VisitableBuilder<ReplicaSetStatus, ?> status;

    public ReplicaSetFluentImpl() {
    }

    public ReplicaSetFluentImpl(ReplicaSet instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public ReplicaSetFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ReplicaSetFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ReplicaSetFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ReplicaSetSpec getSpec() {
        return this.spec != null ? (ReplicaSetSpec)this.spec.build() : null;
    }

    @Override
    public A withSpec(ReplicaSetSpec spec) {
        if (spec != null) {
            this.spec = new ReplicaSetSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (A)this;
    }

    @Override
    public ReplicaSetFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public ReplicaSetFluent.SpecNested<A> withNewSpecLike(ReplicaSetSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public ReplicaSetFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public ReplicaSetStatus getStatus() {
        return this.status != null ? (ReplicaSetStatus)this.status.build() : null;
    }

    @Override
    public A withStatus(ReplicaSetStatus status) {
        if (status != null) {
            this.status = new ReplicaSetStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (A)this;
    }

    @Override
    public ReplicaSetFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public ReplicaSetFluent.StatusNested<A> withNewStatusLike(ReplicaSetStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public ReplicaSetFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public A withNewStatus(Integer fullyLabeledReplicas, Long observedGeneration, Integer replicas) {
        return this.withStatus(new ReplicaSetStatus(fullyLabeledReplicas, observedGeneration, replicas));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicaSetFluentImpl that = (ReplicaSetFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public class StatusNestedImpl<N>
    extends ReplicaSetStatusFluentImpl<ReplicaSetFluent.StatusNested<N>>
    implements ReplicaSetFluent.StatusNested<N> {
        private final ReplicaSetStatusBuilder builder;

        StatusNestedImpl() {
            this.builder = new ReplicaSetStatusBuilder(this);
        }

        StatusNestedImpl(ReplicaSetStatus item) {
            this.builder = new ReplicaSetStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ReplicaSetFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends ReplicaSetSpecFluentImpl<ReplicaSetFluent.SpecNested<N>>
    implements ReplicaSetFluent.SpecNested<N> {
        private final ReplicaSetSpecBuilder builder;

        SpecNestedImpl() {
            this.builder = new ReplicaSetSpecBuilder(this);
        }

        SpecNestedImpl(ReplicaSetSpec item) {
            this.builder = new ReplicaSetSpecBuilder(this, item);
        }

        @Override
        public N endSpec() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ReplicaSetFluentImpl.this.withSpec(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ReplicaSetFluent.MetadataNested<N>>
    implements ReplicaSetFluent.MetadataNested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ReplicaSetFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

