/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.APIVersion;
import io.fabric8.kubernetes.api.model.extensions.APIVersionBuilder;
import io.fabric8.kubernetes.api.model.extensions.APIVersionFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResource;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceFluent;
import java.util.ArrayList;
import java.util.List;

public class ThirdPartyResourceFluentImpl<A extends ThirdPartyResourceFluent<A>>
extends BaseFluent<A>
implements ThirdPartyResourceFluent<A> {
    String apiVersion;
    String description;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    List<VisitableBuilder<APIVersion, ?>> versions = new ArrayList();

    public ThirdPartyResourceFluentImpl() {
    }

    public ThirdPartyResourceFluentImpl(ThirdPartyResource instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withDescription(instance.getDescription());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withVersions(instance.getVersions());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public A withDescription(String description) {
        this.description = description;
        return (A)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public ThirdPartyResourceFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ThirdPartyResourceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ThirdPartyResourceFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public A addToVersions(APIVersion ... items) {
        for (APIVersion item : items) {
            APIVersionBuilder builder = new APIVersionBuilder(item);
            this._visitables.add(builder);
            this.versions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVersions(APIVersion ... items) {
        for (APIVersion item : items) {
            APIVersionBuilder builder = new APIVersionBuilder(item);
            this._visitables.remove(builder);
            this.versions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<APIVersion> getVersions() {
        return this.build(this.versions);
    }

    @Override
    public A withVersions(List<APIVersion> versions) {
        this.versions.clear();
        if (versions != null) {
            for (APIVersion item : versions) {
                this.addToVersions(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withVersions(APIVersion ... versions) {
        this.versions.clear();
        if (versions != null) {
            for (APIVersion item : versions) {
                this.addToVersions(item);
            }
        }
        return (A)this;
    }

    @Override
    public ThirdPartyResourceFluent.VersionsNested<A> addNewVersion() {
        return new VersionsNestedImpl();
    }

    @Override
    public ThirdPartyResourceFluent.VersionsNested<A> addNewVersionLike(APIVersion item) {
        return new VersionsNestedImpl(item);
    }

    @Override
    public A addNewVersion(String name) {
        return this.addToVersions(new APIVersion(name));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThirdPartyResourceFluentImpl that = (ThirdPartyResourceFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.versions != null ? !this.versions.equals(that.versions) : that.versions != null);
    }

    public class VersionsNestedImpl<N>
    extends APIVersionFluentImpl<ThirdPartyResourceFluent.VersionsNested<N>>
    implements ThirdPartyResourceFluent.VersionsNested<N> {
        private final APIVersionBuilder builder;

        VersionsNestedImpl(APIVersion item) {
            this.builder = new APIVersionBuilder(this, item);
        }

        VersionsNestedImpl() {
            this.builder = new APIVersionBuilder(this);
        }

        @Override
        public N and() {
            return (N)ThirdPartyResourceFluentImpl.this.addToVersions(this.builder.build());
        }

        @Override
        public N endVersion() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ThirdPartyResourceFluent.MetadataNested<N>>
    implements ThirdPartyResourceFluent.MetadataNested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ThirdPartyResourceFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

