/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildConfigSpec;
import io.fabric8.openshift.api.model.BuildConfigSpecBuilder;
import io.fabric8.openshift.api.model.BuildConfigSpecFluentImpl;
import io.fabric8.openshift.api.model.BuildConfigStatus;
import io.fabric8.openshift.api.model.BuildConfigStatusBuilder;
import io.fabric8.openshift.api.model.BuildConfigStatusFluentImpl;

public class BuildConfigFluentImpl<A extends BuildConfigFluent<A>>
extends BaseFluent<A>
implements BuildConfigFluent<A> {
    String apiVersion;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<BuildConfigSpec, ?> spec;
    VisitableBuilder<BuildConfigStatus, ?> status;

    public BuildConfigFluentImpl() {
    }

    public BuildConfigFluentImpl(BuildConfig instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public BuildConfigFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public BuildConfigFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public BuildConfigFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public BuildConfigSpec getSpec() {
        return this.spec != null ? (BuildConfigSpec)this.spec.build() : null;
    }

    @Override
    public A withSpec(BuildConfigSpec spec) {
        if (spec != null) {
            this.spec = new BuildConfigSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (A)this;
    }

    @Override
    public BuildConfigFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public BuildConfigFluent.SpecNested<A> withNewSpecLike(BuildConfigSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public BuildConfigFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public BuildConfigStatus getStatus() {
        return this.status != null ? (BuildConfigStatus)this.status.build() : null;
    }

    @Override
    public A withStatus(BuildConfigStatus status) {
        if (status != null) {
            this.status = new BuildConfigStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (A)this;
    }

    @Override
    public BuildConfigFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public BuildConfigFluent.StatusNested<A> withNewStatusLike(BuildConfigStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public BuildConfigFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public A withNewStatus(Integer lastVersion) {
        return this.withStatus(new BuildConfigStatus(lastVersion));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildConfigFluentImpl that = (BuildConfigFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public class StatusNestedImpl<N>
    extends BuildConfigStatusFluentImpl<BuildConfigFluent.StatusNested<N>>
    implements BuildConfigFluent.StatusNested<N> {
        private final BuildConfigStatusBuilder builder;

        StatusNestedImpl() {
            this.builder = new BuildConfigStatusBuilder(this);
        }

        StatusNestedImpl(BuildConfigStatus item) {
            this.builder = new BuildConfigStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildConfigFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends BuildConfigSpecFluentImpl<BuildConfigFluent.SpecNested<N>>
    implements BuildConfigFluent.SpecNested<N> {
        private final BuildConfigSpecBuilder builder;

        SpecNestedImpl() {
            this.builder = new BuildConfigSpecBuilder(this);
        }

        SpecNestedImpl(BuildConfigSpec item) {
            this.builder = new BuildConfigSpecBuilder(this, item);
        }

        @Override
        public N endSpec() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildConfigFluentImpl.this.withSpec(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<BuildConfigFluent.MetadataNested<N>>
    implements BuildConfigFluent.MetadataNested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildConfigFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

