/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.BinaryBuildSource;
import io.fabric8.openshift.api.model.BinaryBuildSourceBuilder;
import io.fabric8.openshift.api.model.BinaryBuildSourceFluentImpl;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.BuildSourceFluent;
import io.fabric8.openshift.api.model.GitBuildSource;
import io.fabric8.openshift.api.model.GitBuildSourceBuilder;
import io.fabric8.openshift.api.model.GitBuildSourceFluentImpl;
import io.fabric8.openshift.api.model.ImageSource;
import io.fabric8.openshift.api.model.ImageSourceBuilder;
import io.fabric8.openshift.api.model.ImageSourceFluentImpl;
import io.fabric8.openshift.api.model.SecretBuildSource;
import io.fabric8.openshift.api.model.SecretBuildSourceBuilder;
import io.fabric8.openshift.api.model.SecretBuildSourceFluentImpl;
import java.util.ArrayList;
import java.util.List;

public class BuildSourceFluentImpl<A extends BuildSourceFluent<A>>
extends BaseFluent<A>
implements BuildSourceFluent<A> {
    VisitableBuilder<BinaryBuildSource, ?> binary;
    String contextDir;
    String dockerfile;
    VisitableBuilder<GitBuildSource, ?> git;
    List<VisitableBuilder<ImageSource, ?>> images = new ArrayList();
    List<VisitableBuilder<SecretBuildSource, ?>> secrets = new ArrayList();
    VisitableBuilder<LocalObjectReference, ?> sourceSecret;
    String type;

    public BuildSourceFluentImpl() {
    }

    public BuildSourceFluentImpl(BuildSource instance) {
        this.withBinary(instance.getBinary());
        this.withContextDir(instance.getContextDir());
        this.withDockerfile(instance.getDockerfile());
        this.withGit(instance.getGit());
        this.withImages(instance.getImages());
        this.withSecrets(instance.getSecrets());
        this.withSourceSecret(instance.getSourceSecret());
        this.withType(instance.getType());
    }

    @Override
    public BinaryBuildSource getBinary() {
        return this.binary != null ? (BinaryBuildSource)this.binary.build() : null;
    }

    @Override
    public A withBinary(BinaryBuildSource binary) {
        if (binary != null) {
            this.binary = new BinaryBuildSourceBuilder(binary);
            this._visitables.add(this.binary);
        }
        return (A)this;
    }

    @Override
    public BuildSourceFluent.BinaryNested<A> withNewBinary() {
        return new BinaryNestedImpl();
    }

    @Override
    public BuildSourceFluent.BinaryNested<A> withNewBinaryLike(BinaryBuildSource item) {
        return new BinaryNestedImpl(item);
    }

    @Override
    public BuildSourceFluent.BinaryNested<A> editBinary() {
        return this.withNewBinaryLike(this.getBinary());
    }

    @Override
    public A withNewBinary(String asFile) {
        return this.withBinary(new BinaryBuildSource(asFile));
    }

    @Override
    public String getContextDir() {
        return this.contextDir;
    }

    @Override
    public A withContextDir(String contextDir) {
        this.contextDir = contextDir;
        return (A)this;
    }

    @Override
    public String getDockerfile() {
        return this.dockerfile;
    }

    @Override
    public A withDockerfile(String dockerfile) {
        this.dockerfile = dockerfile;
        return (A)this;
    }

    @Override
    public GitBuildSource getGit() {
        return this.git != null ? (GitBuildSource)this.git.build() : null;
    }

    @Override
    public A withGit(GitBuildSource git) {
        if (git != null) {
            this.git = new GitBuildSourceBuilder(git);
            this._visitables.add(this.git);
        }
        return (A)this;
    }

    @Override
    public BuildSourceFluent.GitNested<A> withNewGit() {
        return new GitNestedImpl();
    }

    @Override
    public BuildSourceFluent.GitNested<A> withNewGitLike(GitBuildSource item) {
        return new GitNestedImpl(item);
    }

    @Override
    public BuildSourceFluent.GitNested<A> editGit() {
        return this.withNewGitLike(this.getGit());
    }

    @Override
    public A withNewGit(String httpProxy, String httpsProxy, String ref, String uri) {
        return this.withGit(new GitBuildSource(httpProxy, httpsProxy, ref, uri));
    }

    @Override
    public A addToImages(ImageSource ... items) {
        for (ImageSource item : items) {
            ImageSourceBuilder builder = new ImageSourceBuilder(item);
            this._visitables.add(builder);
            this.images.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromImages(ImageSource ... items) {
        for (ImageSource item : items) {
            ImageSourceBuilder builder = new ImageSourceBuilder(item);
            this._visitables.remove(builder);
            this.images.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<ImageSource> getImages() {
        return this.build(this.images);
    }

    @Override
    public A withImages(List<ImageSource> images) {
        this.images.clear();
        if (images != null) {
            for (ImageSource item : images) {
                this.addToImages(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withImages(ImageSource ... images) {
        this.images.clear();
        if (images != null) {
            for (ImageSource item : images) {
                this.addToImages(item);
            }
        }
        return (A)this;
    }

    @Override
    public BuildSourceFluent.ImagesNested<A> addNewImage() {
        return new ImagesNestedImpl();
    }

    @Override
    public BuildSourceFluent.ImagesNested<A> addNewImageLike(ImageSource item) {
        return new ImagesNestedImpl(item);
    }

    @Override
    public A addToSecrets(SecretBuildSource ... items) {
        for (SecretBuildSource item : items) {
            SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);
            this._visitables.add(builder);
            this.secrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSecrets(SecretBuildSource ... items) {
        for (SecretBuildSource item : items) {
            SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);
            this._visitables.remove(builder);
            this.secrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<SecretBuildSource> getSecrets() {
        return this.build(this.secrets);
    }

    @Override
    public A withSecrets(List<SecretBuildSource> secrets) {
        this.secrets.clear();
        if (secrets != null) {
            for (SecretBuildSource item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withSecrets(SecretBuildSource ... secrets) {
        this.secrets.clear();
        if (secrets != null) {
            for (SecretBuildSource item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public BuildSourceFluent.SecretsNested<A> addNewSecret() {
        return new SecretsNestedImpl();
    }

    @Override
    public BuildSourceFluent.SecretsNested<A> addNewSecretLike(SecretBuildSource item) {
        return new SecretsNestedImpl(item);
    }

    @Override
    public LocalObjectReference getSourceSecret() {
        return this.sourceSecret != null ? (LocalObjectReference)this.sourceSecret.build() : null;
    }

    @Override
    public A withSourceSecret(LocalObjectReference sourceSecret) {
        if (sourceSecret != null) {
            this.sourceSecret = new LocalObjectReferenceBuilder(sourceSecret);
            this._visitables.add(this.sourceSecret);
        }
        return (A)this;
    }

    @Override
    public BuildSourceFluent.SourceSecretNested<A> withNewSourceSecret() {
        return new SourceSecretNestedImpl();
    }

    @Override
    public BuildSourceFluent.SourceSecretNested<A> withNewSourceSecretLike(LocalObjectReference item) {
        return new SourceSecretNestedImpl(item);
    }

    @Override
    public BuildSourceFluent.SourceSecretNested<A> editSourceSecret() {
        return this.withNewSourceSecretLike(this.getSourceSecret());
    }

    @Override
    public A withNewSourceSecret(String name) {
        return this.withSourceSecret(new LocalObjectReference(name));
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildSourceFluentImpl that = (BuildSourceFluentImpl)o;
        if (this.binary != null ? !this.binary.equals(that.binary) : that.binary != null) {
            return false;
        }
        if (this.contextDir != null ? !this.contextDir.equals(that.contextDir) : that.contextDir != null) {
            return false;
        }
        if (this.dockerfile != null ? !this.dockerfile.equals(that.dockerfile) : that.dockerfile != null) {
            return false;
        }
        if (this.git != null ? !this.git.equals(that.git) : that.git != null) {
            return false;
        }
        if (this.images != null ? !this.images.equals(that.images) : that.images != null) {
            return false;
        }
        if (this.secrets != null ? !this.secrets.equals(that.secrets) : that.secrets != null) {
            return false;
        }
        if (this.sourceSecret != null ? !this.sourceSecret.equals(that.sourceSecret) : that.sourceSecret != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public class SourceSecretNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<BuildSourceFluent.SourceSecretNested<N>>
    implements BuildSourceFluent.SourceSecretNested<N> {
        private final LocalObjectReferenceBuilder builder;

        SourceSecretNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        SourceSecretNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluentImpl.this.withSourceSecret(this.builder.build());
        }

        @Override
        public N endSourceSecret() {
            return this.and();
        }
    }

    public class SecretsNestedImpl<N>
    extends SecretBuildSourceFluentImpl<BuildSourceFluent.SecretsNested<N>>
    implements BuildSourceFluent.SecretsNested<N> {
        private final SecretBuildSourceBuilder builder;

        SecretsNestedImpl() {
            this.builder = new SecretBuildSourceBuilder(this);
        }

        SecretsNestedImpl(SecretBuildSource item) {
            this.builder = new SecretBuildSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluentImpl.this.addToSecrets(this.builder.build());
        }

        @Override
        public N endSecret() {
            return this.and();
        }
    }

    public class ImagesNestedImpl<N>
    extends ImageSourceFluentImpl<BuildSourceFluent.ImagesNested<N>>
    implements BuildSourceFluent.ImagesNested<N> {
        private final ImageSourceBuilder builder;

        ImagesNestedImpl(ImageSource item) {
            this.builder = new ImageSourceBuilder(this, item);
        }

        ImagesNestedImpl() {
            this.builder = new ImageSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluentImpl.this.addToImages(this.builder.build());
        }

        @Override
        public N endImage() {
            return this.and();
        }
    }

    public class GitNestedImpl<N>
    extends GitBuildSourceFluentImpl<BuildSourceFluent.GitNested<N>>
    implements BuildSourceFluent.GitNested<N> {
        private final GitBuildSourceBuilder builder;

        GitNestedImpl(GitBuildSource item) {
            this.builder = new GitBuildSourceBuilder(this, item);
        }

        GitNestedImpl() {
            this.builder = new GitBuildSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluentImpl.this.withGit(this.builder.build());
        }

        @Override
        public N endGit() {
            return this.and();
        }
    }

    public class BinaryNestedImpl<N>
    extends BinaryBuildSourceFluentImpl<BuildSourceFluent.BinaryNested<N>>
    implements BuildSourceFluent.BinaryNested<N> {
        private final BinaryBuildSourceBuilder builder;

        BinaryNestedImpl() {
            this.builder = new BinaryBuildSourceBuilder(this);
        }

        BinaryNestedImpl(BinaryBuildSource item) {
            this.builder = new BinaryBuildSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluentImpl.this.withBinary(this.builder.build());
        }

        @Override
        public N endBinary() {
            return this.and();
        }
    }
}

