/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.BuildSpec;
import io.fabric8.openshift.api.model.BuildSpecFluent;
import io.fabric8.openshift.api.model.BuildSpecFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class BuildSpecBuilder
extends BuildSpecFluentImpl<BuildSpecBuilder>
implements VisitableBuilder<BuildSpec, BuildSpecBuilder> {
    BuildSpecFluent<?> fluent;

    public BuildSpecBuilder() {
        this(new BuildSpec());
    }

    public BuildSpecBuilder(BuildSpecFluent<?> fluent) {
        this(fluent, new BuildSpec());
    }

    public BuildSpecBuilder(BuildSpecFluent<?> fluent, BuildSpec instance) {
        this.fluent = fluent;
        fluent.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds());
        fluent.withOutput(instance.getOutput());
        fluent.withPostCommit(instance.getPostCommit());
        fluent.withResources(instance.getResources());
        fluent.withRevision(instance.getRevision());
        fluent.withServiceAccount(instance.getServiceAccount());
        fluent.withSource(instance.getSource());
        fluent.withStrategy(instance.getStrategy());
    }

    public BuildSpecBuilder(BuildSpec instance) {
        this.fluent = this;
        this.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds());
        this.withOutput(instance.getOutput());
        this.withPostCommit(instance.getPostCommit());
        this.withResources(instance.getResources());
        this.withRevision(instance.getRevision());
        this.withServiceAccount(instance.getServiceAccount());
        this.withSource(instance.getSource());
        this.withStrategy(instance.getStrategy());
    }

    @Override
    public BuildSpec build() {
        BuildSpec buildable = new BuildSpec(this.fluent.getCompletionDeadlineSeconds(), this.fluent.getOutput(), this.fluent.getPostCommit(), this.fluent.getResources(), this.fluent.getRevision(), this.fluent.getServiceAccount(), this.fluent.getSource(), this.fluent.getStrategy());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildSpecBuilder that = (BuildSpecBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

