/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.BuildStrategy;
import io.fabric8.openshift.api.model.BuildStrategyFluent;
import io.fabric8.openshift.api.model.BuildStrategyFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class BuildStrategyBuilder
extends BuildStrategyFluentImpl<BuildStrategyBuilder>
implements VisitableBuilder<BuildStrategy, BuildStrategyBuilder> {
    BuildStrategyFluent<?> fluent;

    public BuildStrategyBuilder() {
        this(new BuildStrategy());
    }

    public BuildStrategyBuilder(BuildStrategyFluent<?> fluent) {
        this(fluent, new BuildStrategy());
    }

    public BuildStrategyBuilder(BuildStrategyFluent<?> fluent, BuildStrategy instance) {
        this.fluent = fluent;
        fluent.withCustomStrategy(instance.getCustomStrategy());
        fluent.withDockerStrategy(instance.getDockerStrategy());
        fluent.withJenkinsPipelineStrategy(instance.getJenkinsPipelineStrategy());
        fluent.withSourceStrategy(instance.getSourceStrategy());
        fluent.withType(instance.getType());
    }

    public BuildStrategyBuilder(BuildStrategy instance) {
        this.fluent = this;
        this.withCustomStrategy(instance.getCustomStrategy());
        this.withDockerStrategy(instance.getDockerStrategy());
        this.withJenkinsPipelineStrategy(instance.getJenkinsPipelineStrategy());
        this.withSourceStrategy(instance.getSourceStrategy());
        this.withType(instance.getType());
    }

    @Override
    public BuildStrategy build() {
        BuildStrategy buildable = new BuildStrategy(this.fluent.getCustomStrategy(), this.fluent.getDockerStrategy(), this.fluent.getJenkinsPipelineStrategy(), this.fluent.getSourceStrategy(), this.fluent.getType());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildStrategyBuilder that = (BuildStrategyBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

