/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.ListMetaFluentImpl;
import io.fabric8.openshift.api.model.ClusterPolicy;
import io.fabric8.openshift.api.model.ClusterPolicyBuilder;
import io.fabric8.openshift.api.model.ClusterPolicyFluentImpl;
import io.fabric8.openshift.api.model.ClusterPolicyList;
import io.fabric8.openshift.api.model.ClusterPolicyListFluent;
import java.util.ArrayList;
import java.util.List;

public class ClusterPolicyListFluentImpl<A extends ClusterPolicyListFluent<A>>
extends BaseFluent<A>
implements ClusterPolicyListFluent<A> {
    String apiVersion;
    List<VisitableBuilder<ClusterPolicy, ?>> items = new ArrayList();
    String kind;
    VisitableBuilder<ListMeta, ?> metadata;

    public ClusterPolicyListFluentImpl() {
    }

    public ClusterPolicyListFluentImpl(ClusterPolicyList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public A addToItems(ClusterPolicy ... items) {
        for (ClusterPolicy item : items) {
            ClusterPolicyBuilder builder = new ClusterPolicyBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(ClusterPolicy ... items) {
        for (ClusterPolicy item : items) {
            ClusterPolicyBuilder builder = new ClusterPolicyBuilder(item);
            this._visitables.remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<ClusterPolicy> getItems() {
        return this.build(this.items);
    }

    @Override
    public A withItems(List<ClusterPolicy> items) {
        this.items.clear();
        if (items != null) {
            for (ClusterPolicy item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withItems(ClusterPolicy ... items) {
        this.items.clear();
        if (items != null) {
            for (ClusterPolicy item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public ClusterPolicyListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public ClusterPolicyListFluent.ItemsNested<A> addNewItemLike(ClusterPolicy item) {
        return new ItemsNestedImpl(item);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata != null ? (ListMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public ClusterPolicyListFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ClusterPolicyListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ClusterPolicyListFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public A withNewMetadata(String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterPolicyListFluentImpl that = (ClusterPolicyListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public class MetadataNestedImpl<N>
    extends ListMetaFluentImpl<ClusterPolicyListFluent.MetadataNested<N>>
    implements ClusterPolicyListFluent.MetadataNested<N> {
        private final ListMetaBuilder builder;

        MetadataNestedImpl() {
            this.builder = new ListMetaBuilder(this);
        }

        MetadataNestedImpl(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterPolicyListFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ItemsNestedImpl<N>
    extends ClusterPolicyFluentImpl<ClusterPolicyListFluent.ItemsNested<N>>
    implements ClusterPolicyListFluent.ItemsNested<N> {
        private final ClusterPolicyBuilder builder;

        ItemsNestedImpl() {
            this.builder = new ClusterPolicyBuilder(this);
        }

        ItemsNestedImpl(ClusterPolicy item) {
            this.builder = new ClusterPolicyBuilder(this, item);
        }

        @Override
        public N endItem() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ClusterPolicyListFluentImpl.this.addToItems(this.builder.build());
        }
    }
}

