/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.CustomBuildStrategy;
import io.fabric8.openshift.api.model.CustomBuildStrategyFluent;
import io.fabric8.openshift.api.model.SecretSpec;
import io.fabric8.openshift.api.model.SecretSpecBuilder;
import io.fabric8.openshift.api.model.SecretSpecFluentImpl;
import java.util.ArrayList;
import java.util.List;

public class CustomBuildStrategyFluentImpl<A extends CustomBuildStrategyFluent<A>>
extends BaseFluent<A>
implements CustomBuildStrategyFluent<A> {
    String buildAPIVersion;
    List<VisitableBuilder<EnvVar, ?>> env = new ArrayList();
    Boolean exposeDockerSocket;
    Boolean forcePull;
    VisitableBuilder<ObjectReference, ?> from;
    VisitableBuilder<LocalObjectReference, ?> pullSecret;
    List<VisitableBuilder<SecretSpec, ?>> secrets = new ArrayList();

    public CustomBuildStrategyFluentImpl() {
    }

    public CustomBuildStrategyFluentImpl(CustomBuildStrategy instance) {
        this.withBuildAPIVersion(instance.getBuildAPIVersion());
        this.withEnv(instance.getEnv());
        this.withExposeDockerSocket(instance.getExposeDockerSocket());
        this.withForcePull(instance.getForcePull());
        this.withFrom(instance.getFrom());
        this.withPullSecret(instance.getPullSecret());
        this.withSecrets(instance.getSecrets());
    }

    @Override
    public String getBuildAPIVersion() {
        return this.buildAPIVersion;
    }

    @Override
    public A withBuildAPIVersion(String buildAPIVersion) {
        this.buildAPIVersion = buildAPIVersion;
        return (A)this;
    }

    @Override
    public A addToEnv(EnvVar ... items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.add(builder);
            this.env.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnv(EnvVar ... items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.remove(builder);
            this.env.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<EnvVar> getEnv() {
        return this.build(this.env);
    }

    @Override
    public A withEnv(List<EnvVar> env) {
        this.env.clear();
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withEnv(EnvVar ... env) {
        this.env.clear();
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    @Override
    public CustomBuildStrategyFluent.EnvNested<A> addNewEnv() {
        return new EnvNestedImpl();
    }

    @Override
    public CustomBuildStrategyFluent.EnvNested<A> addNewEnvLike(EnvVar item) {
        return new EnvNestedImpl(item);
    }

    @Override
    public Boolean isExposeDockerSocket() {
        return this.exposeDockerSocket;
    }

    @Override
    public A withExposeDockerSocket(Boolean exposeDockerSocket) {
        this.exposeDockerSocket = exposeDockerSocket;
        return (A)this;
    }

    @Override
    public Boolean isForcePull() {
        return this.forcePull;
    }

    @Override
    public A withForcePull(Boolean forcePull) {
        this.forcePull = forcePull;
        return (A)this;
    }

    @Override
    public ObjectReference getFrom() {
        return this.from != null ? (ObjectReference)this.from.build() : null;
    }

    @Override
    public A withFrom(ObjectReference from) {
        if (from != null) {
            this.from = new ObjectReferenceBuilder(from);
            this._visitables.add(this.from);
        }
        return (A)this;
    }

    @Override
    public CustomBuildStrategyFluent.FromNested<A> withNewFrom() {
        return new FromNestedImpl();
    }

    @Override
    public CustomBuildStrategyFluent.FromNested<A> withNewFromLike(ObjectReference item) {
        return new FromNestedImpl(item);
    }

    @Override
    public CustomBuildStrategyFluent.FromNested<A> editFrom() {
        return this.withNewFromLike(this.getFrom());
    }

    @Override
    public LocalObjectReference getPullSecret() {
        return this.pullSecret != null ? (LocalObjectReference)this.pullSecret.build() : null;
    }

    @Override
    public A withPullSecret(LocalObjectReference pullSecret) {
        if (pullSecret != null) {
            this.pullSecret = new LocalObjectReferenceBuilder(pullSecret);
            this._visitables.add(this.pullSecret);
        }
        return (A)this;
    }

    @Override
    public CustomBuildStrategyFluent.PullSecretNested<A> withNewPullSecret() {
        return new PullSecretNestedImpl();
    }

    @Override
    public CustomBuildStrategyFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item) {
        return new PullSecretNestedImpl(item);
    }

    @Override
    public CustomBuildStrategyFluent.PullSecretNested<A> editPullSecret() {
        return this.withNewPullSecretLike(this.getPullSecret());
    }

    @Override
    public A withNewPullSecret(String name) {
        return this.withPullSecret(new LocalObjectReference(name));
    }

    @Override
    public A addToSecrets(SecretSpec ... items) {
        for (SecretSpec item : items) {
            SecretSpecBuilder builder = new SecretSpecBuilder(item);
            this._visitables.add(builder);
            this.secrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSecrets(SecretSpec ... items) {
        for (SecretSpec item : items) {
            SecretSpecBuilder builder = new SecretSpecBuilder(item);
            this._visitables.remove(builder);
            this.secrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<SecretSpec> getSecrets() {
        return this.build(this.secrets);
    }

    @Override
    public A withSecrets(List<SecretSpec> secrets) {
        this.secrets.clear();
        if (secrets != null) {
            for (SecretSpec item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withSecrets(SecretSpec ... secrets) {
        this.secrets.clear();
        if (secrets != null) {
            for (SecretSpec item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public CustomBuildStrategyFluent.SecretsNested<A> addNewSecret() {
        return new SecretsNestedImpl();
    }

    @Override
    public CustomBuildStrategyFluent.SecretsNested<A> addNewSecretLike(SecretSpec item) {
        return new SecretsNestedImpl(item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomBuildStrategyFluentImpl that = (CustomBuildStrategyFluentImpl)o;
        if (this.buildAPIVersion != null ? !this.buildAPIVersion.equals(that.buildAPIVersion) : that.buildAPIVersion != null) {
            return false;
        }
        if (this.env != null ? !this.env.equals(that.env) : that.env != null) {
            return false;
        }
        if (this.exposeDockerSocket != null ? !this.exposeDockerSocket.equals(that.exposeDockerSocket) : that.exposeDockerSocket != null) {
            return false;
        }
        if (this.forcePull != null ? !this.forcePull.equals(that.forcePull) : that.forcePull != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        if (this.pullSecret != null ? !this.pullSecret.equals(that.pullSecret) : that.pullSecret != null) {
            return false;
        }
        return !(this.secrets != null ? !this.secrets.equals(that.secrets) : that.secrets != null);
    }

    public class SecretsNestedImpl<N>
    extends SecretSpecFluentImpl<CustomBuildStrategyFluent.SecretsNested<N>>
    implements CustomBuildStrategyFluent.SecretsNested<N> {
        private final SecretSpecBuilder builder;

        SecretsNestedImpl() {
            this.builder = new SecretSpecBuilder(this);
        }

        SecretsNestedImpl(SecretSpec item) {
            this.builder = new SecretSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CustomBuildStrategyFluentImpl.this.addToSecrets(this.builder.build());
        }

        @Override
        public N endSecret() {
            return this.and();
        }
    }

    public class PullSecretNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<CustomBuildStrategyFluent.PullSecretNested<N>>
    implements CustomBuildStrategyFluent.PullSecretNested<N> {
        private final LocalObjectReferenceBuilder builder;

        PullSecretNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        PullSecretNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CustomBuildStrategyFluentImpl.this.withPullSecret(this.builder.build());
        }

        @Override
        public N endPullSecret() {
            return this.and();
        }
    }

    public class FromNestedImpl<N>
    extends ObjectReferenceFluentImpl<CustomBuildStrategyFluent.FromNested<N>>
    implements CustomBuildStrategyFluent.FromNested<N> {
        private final ObjectReferenceBuilder builder;

        FromNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        FromNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N endFrom() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)CustomBuildStrategyFluentImpl.this.withFrom(this.builder.build());
        }
    }

    public class EnvNestedImpl<N>
    extends EnvVarFluentImpl<CustomBuildStrategyFluent.EnvNested<N>>
    implements CustomBuildStrategyFluent.EnvNested<N> {
        private final EnvVarBuilder builder;

        EnvNestedImpl() {
            this.builder = new EnvVarBuilder(this);
        }

        EnvNestedImpl(EnvVar item) {
            this.builder = new EnvVarBuilder(this, item);
        }

        @Override
        public N endEnv() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)CustomBuildStrategyFluentImpl.this.addToEnv(this.builder.build());
        }
    }
}

