/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.ImageSourcePath;
import io.fabric8.openshift.api.model.ImageSourcePathFluent;
import io.fabric8.openshift.api.model.ImageSourcePathFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ImageSourcePathBuilder
extends ImageSourcePathFluentImpl<ImageSourcePathBuilder>
implements VisitableBuilder<ImageSourcePath, ImageSourcePathBuilder> {
    ImageSourcePathFluent<?> fluent;

    public ImageSourcePathBuilder() {
        this(new ImageSourcePath());
    }

    public ImageSourcePathBuilder(ImageSourcePathFluent<?> fluent) {
        this(fluent, new ImageSourcePath());
    }

    public ImageSourcePathBuilder(ImageSourcePathFluent<?> fluent, ImageSourcePath instance) {
        this.fluent = fluent;
        fluent.withDestinationDir(instance.getDestinationDir());
        fluent.withSourcePath(instance.getSourcePath());
    }

    public ImageSourcePathBuilder(ImageSourcePath instance) {
        this.fluent = this;
        this.withDestinationDir(instance.getDestinationDir());
        this.withSourcePath(instance.getSourcePath());
    }

    @Override
    public ImageSourcePath build() {
        ImageSourcePath buildable = new ImageSourcePath(this.fluent.getDestinationDir(), this.fluent.getSourcePath());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageSourcePathBuilder that = (ImageSourcePathBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

