/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.NamedRoleBinding;
import io.fabric8.openshift.api.model.NamedRoleBindingFluent;
import io.fabric8.openshift.api.model.RoleBinding;
import io.fabric8.openshift.api.model.RoleBindingBuilder;
import io.fabric8.openshift.api.model.RoleBindingFluentImpl;

public class NamedRoleBindingFluentImpl<A extends NamedRoleBindingFluent<A>>
extends BaseFluent<A>
implements NamedRoleBindingFluent<A> {
    String name;
    VisitableBuilder<RoleBinding, ?> roleBinding;

    public NamedRoleBindingFluentImpl() {
    }

    public NamedRoleBindingFluentImpl(NamedRoleBinding instance) {
        this.withName(instance.getName());
        this.withRoleBinding(instance.getRoleBinding());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public RoleBinding getRoleBinding() {
        return this.roleBinding != null ? (RoleBinding)this.roleBinding.build() : null;
    }

    @Override
    public A withRoleBinding(RoleBinding roleBinding) {
        if (roleBinding != null) {
            this.roleBinding = new RoleBindingBuilder(roleBinding);
            this._visitables.add(this.roleBinding);
        }
        return (A)this;
    }

    @Override
    public NamedRoleBindingFluent.RoleBindingNested<A> withNewRoleBinding() {
        return new RoleBindingNestedImpl();
    }

    @Override
    public NamedRoleBindingFluent.RoleBindingNested<A> withNewRoleBindingLike(RoleBinding item) {
        return new RoleBindingNestedImpl(item);
    }

    @Override
    public NamedRoleBindingFluent.RoleBindingNested<A> editRoleBinding() {
        return this.withNewRoleBindingLike(this.getRoleBinding());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedRoleBindingFluentImpl that = (NamedRoleBindingFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.roleBinding != null ? !this.roleBinding.equals(that.roleBinding) : that.roleBinding != null);
    }

    public class RoleBindingNestedImpl<N>
    extends RoleBindingFluentImpl<NamedRoleBindingFluent.RoleBindingNested<N>>
    implements NamedRoleBindingFluent.RoleBindingNested<N> {
        private final RoleBindingBuilder builder;

        RoleBindingNestedImpl(RoleBinding item) {
            this.builder = new RoleBindingBuilder(this, item);
        }

        RoleBindingNestedImpl() {
            this.builder = new RoleBindingBuilder(this);
        }

        @Override
        public N endRoleBinding() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)NamedRoleBindingFluentImpl.this.withRoleBinding(this.builder.build());
        }
    }
}

