/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.NamedRole;
import io.fabric8.openshift.api.model.NamedRoleFluent;
import io.fabric8.openshift.api.model.Role;
import io.fabric8.openshift.api.model.RoleBuilder;
import io.fabric8.openshift.api.model.RoleFluentImpl;

public class NamedRoleFluentImpl<A extends NamedRoleFluent<A>>
extends BaseFluent<A>
implements NamedRoleFluent<A> {
    String name;
    VisitableBuilder<Role, ?> role;

    public NamedRoleFluentImpl() {
    }

    public NamedRoleFluentImpl(NamedRole instance) {
        this.withName(instance.getName());
        this.withRole(instance.getRole());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Role getRole() {
        return this.role != null ? (Role)this.role.build() : null;
    }

    @Override
    public A withRole(Role role) {
        if (role != null) {
            this.role = new RoleBuilder(role);
            this._visitables.add(this.role);
        }
        return (A)this;
    }

    @Override
    public NamedRoleFluent.RoleNested<A> withNewRole() {
        return new RoleNestedImpl();
    }

    @Override
    public NamedRoleFluent.RoleNested<A> withNewRoleLike(Role item) {
        return new RoleNestedImpl(item);
    }

    @Override
    public NamedRoleFluent.RoleNested<A> editRole() {
        return this.withNewRoleLike(this.getRole());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedRoleFluentImpl that = (NamedRoleFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.role != null ? !this.role.equals(that.role) : that.role != null);
    }

    public class RoleNestedImpl<N>
    extends RoleFluentImpl<NamedRoleFluent.RoleNested<N>>
    implements NamedRoleFluent.RoleNested<N> {
        private final RoleBuilder builder;

        RoleNestedImpl() {
            this.builder = new RoleBuilder(this);
        }

        RoleNestedImpl(Role item) {
            this.builder = new RoleBuilder(this, item);
        }

        @Override
        public N endRole() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)NamedRoleFluentImpl.this.withRole(this.builder.build());
        }
    }
}

