/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.OAuthAccessToken;
import io.fabric8.openshift.api.model.OAuthAccessTokenFluent;
import io.fabric8.openshift.api.model.OAuthAccessTokenFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class OAuthAccessTokenBuilder
extends OAuthAccessTokenFluentImpl<OAuthAccessTokenBuilder>
implements VisitableBuilder<OAuthAccessToken, OAuthAccessTokenBuilder> {
    OAuthAccessTokenFluent<?> fluent;

    public OAuthAccessTokenBuilder() {
        this(new OAuthAccessToken());
    }

    public OAuthAccessTokenBuilder(OAuthAccessTokenFluent<?> fluent) {
        this(fluent, new OAuthAccessToken());
    }

    public OAuthAccessTokenBuilder(OAuthAccessTokenFluent<?> fluent, OAuthAccessToken instance) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withAuthorizeToken(instance.getAuthorizeToken());
        fluent.withClientName(instance.getClientName());
        fluent.withExpiresIn(instance.getExpiresIn());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withRedirectURI(instance.getRedirectURI());
        fluent.withRefreshToken(instance.getRefreshToken());
        fluent.withScopes(instance.getScopes());
        fluent.withUserName(instance.getUserName());
        fluent.withUserUID(instance.getUserUID());
    }

    public OAuthAccessTokenBuilder(OAuthAccessToken instance) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withAuthorizeToken(instance.getAuthorizeToken());
        this.withClientName(instance.getClientName());
        this.withExpiresIn(instance.getExpiresIn());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRedirectURI(instance.getRedirectURI());
        this.withRefreshToken(instance.getRefreshToken());
        this.withScopes(instance.getScopes());
        this.withUserName(instance.getUserName());
        this.withUserUID(instance.getUserUID());
    }

    @Override
    public OAuthAccessToken build() {
        OAuthAccessToken buildable = new OAuthAccessToken(this.fluent.getApiVersion(), this.fluent.getAuthorizeToken(), this.fluent.getClientName(), this.fluent.getExpiresIn(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getRedirectURI(), this.fluent.getRefreshToken(), this.fluent.getScopes(), this.fluent.getUserName(), this.fluent.getUserUID());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OAuthAccessTokenBuilder that = (OAuthAccessTokenBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

