/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.OAuthClientAuthorization;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationFluent;
import java.util.ArrayList;
import java.util.List;

public class OAuthClientAuthorizationFluentImpl<A extends OAuthClientAuthorizationFluent<A>>
extends BaseFluent<A>
implements OAuthClientAuthorizationFluent<A> {
    String apiVersion;
    String clientName;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    List<String> scopes = new ArrayList<String>();
    String userName;
    String userUID;

    public OAuthClientAuthorizationFluentImpl() {
    }

    public OAuthClientAuthorizationFluentImpl(OAuthClientAuthorization instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withClientName(instance.getClientName());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withScopes(instance.getScopes());
        this.withUserName(instance.getUserName());
        this.withUserUID(instance.getUserUID());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public String getClientName() {
        return this.clientName;
    }

    @Override
    public A withClientName(String clientName) {
        this.clientName = clientName;
        return (A)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public OAuthClientAuthorizationFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public OAuthClientAuthorizationFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public OAuthClientAuthorizationFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public A addToScopes(String ... items) {
        for (String item : items) {
            this.scopes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromScopes(String ... items) {
        for (String item : items) {
            this.scopes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getScopes() {
        return this.scopes;
    }

    @Override
    public A withScopes(List<String> scopes) {
        this.scopes.clear();
        if (scopes != null) {
            for (String item : scopes) {
                this.addToScopes(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withScopes(String ... scopes) {
        this.scopes.clear();
        if (scopes != null) {
            for (String item : scopes) {
                this.addToScopes(item);
            }
        }
        return (A)this;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public A withUserName(String userName) {
        this.userName = userName;
        return (A)this;
    }

    @Override
    public String getUserUID() {
        return this.userUID;
    }

    @Override
    public A withUserUID(String userUID) {
        this.userUID = userUID;
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthClientAuthorizationFluentImpl that = (OAuthClientAuthorizationFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.clientName != null ? !this.clientName.equals(that.clientName) : that.clientName != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.scopes != null ? !this.scopes.equals(that.scopes) : that.scopes != null) {
            return false;
        }
        if (this.userName != null ? !this.userName.equals(that.userName) : that.userName != null) {
            return false;
        }
        return !(this.userUID != null ? !this.userUID.equals(that.userUID) : that.userUID != null);
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<OAuthClientAuthorizationFluent.MetadataNested<N>>
    implements OAuthClientAuthorizationFluent.MetadataNested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)OAuthClientAuthorizationFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

