/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.Parameter;
import io.fabric8.openshift.api.model.ParameterFluent;
import io.fabric8.openshift.api.model.ParameterFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ParameterBuilder
extends ParameterFluentImpl<ParameterBuilder>
implements VisitableBuilder<Parameter, ParameterBuilder> {
    ParameterFluent<?> fluent;

    public ParameterBuilder() {
        this(new Parameter());
    }

    public ParameterBuilder(ParameterFluent<?> fluent) {
        this(fluent, new Parameter());
    }

    public ParameterBuilder(ParameterFluent<?> fluent, Parameter instance) {
        this.fluent = fluent;
        fluent.withDescription(instance.getDescription());
        fluent.withDisplayName(instance.getDisplayName());
        fluent.withFrom(instance.getFrom());
        fluent.withGenerate(instance.getGenerate());
        fluent.withName(instance.getName());
        fluent.withRequired(instance.getRequired());
        fluent.withValue(instance.getValue());
    }

    public ParameterBuilder(Parameter instance) {
        this.fluent = this;
        this.withDescription(instance.getDescription());
        this.withDisplayName(instance.getDisplayName());
        this.withFrom(instance.getFrom());
        this.withGenerate(instance.getGenerate());
        this.withName(instance.getName());
        this.withRequired(instance.getRequired());
        this.withValue(instance.getValue());
    }

    @Override
    public Parameter build() {
        Parameter buildable = new Parameter(this.fluent.getDescription(), this.fluent.getDisplayName(), this.fluent.getFrom(), this.fluent.getGenerate(), this.fluent.getName(), this.fluent.isRequired(), this.fluent.getValue());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterBuilder that = (ParameterBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

