/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteFluent;
import io.fabric8.openshift.api.model.RouteSpec;
import io.fabric8.openshift.api.model.RouteSpecBuilder;
import io.fabric8.openshift.api.model.RouteSpecFluentImpl;
import io.fabric8.openshift.api.model.RouteStatus;
import io.fabric8.openshift.api.model.RouteStatusBuilder;
import io.fabric8.openshift.api.model.RouteStatusFluentImpl;

public class RouteFluentImpl<A extends RouteFluent<A>>
extends BaseFluent<A>
implements RouteFluent<A> {
    String apiVersion;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<RouteSpec, ?> spec;
    VisitableBuilder<RouteStatus, ?> status;

    public RouteFluentImpl() {
    }

    public RouteFluentImpl(Route instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public RouteFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public RouteFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public RouteFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public RouteSpec getSpec() {
        return this.spec != null ? (RouteSpec)this.spec.build() : null;
    }

    @Override
    public A withSpec(RouteSpec spec) {
        if (spec != null) {
            this.spec = new RouteSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (A)this;
    }

    @Override
    public RouteFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public RouteFluent.SpecNested<A> withNewSpecLike(RouteSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public RouteFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public RouteStatus getStatus() {
        return this.status != null ? (RouteStatus)this.status.build() : null;
    }

    @Override
    public A withStatus(RouteStatus status) {
        if (status != null) {
            this.status = new RouteStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (A)this;
    }

    @Override
    public RouteFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public RouteFluent.StatusNested<A> withNewStatusLike(RouteStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public RouteFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouteFluentImpl that = (RouteFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public class StatusNestedImpl<N>
    extends RouteStatusFluentImpl<RouteFluent.StatusNested<N>>
    implements RouteFluent.StatusNested<N> {
        private final RouteStatusBuilder builder;

        StatusNestedImpl() {
            this.builder = new RouteStatusBuilder(this);
        }

        StatusNestedImpl(RouteStatus item) {
            this.builder = new RouteStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RouteFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends RouteSpecFluentImpl<RouteFluent.SpecNested<N>>
    implements RouteFluent.SpecNested<N> {
        private final RouteSpecBuilder builder;

        SpecNestedImpl() {
            this.builder = new RouteSpecBuilder(this);
        }

        SpecNestedImpl(RouteSpec item) {
            this.builder = new RouteSpecBuilder(this, item);
        }

        @Override
        public N endSpec() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)RouteFluentImpl.this.withSpec(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<RouteFluent.MetadataNested<N>>
    implements RouteFluent.MetadataNested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)RouteFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

