/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.SecretBuildSource;
import io.fabric8.openshift.api.model.SecretBuildSourceFluent;
import io.fabric8.openshift.api.model.SecretBuildSourceFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class SecretBuildSourceBuilder
extends SecretBuildSourceFluentImpl<SecretBuildSourceBuilder>
implements VisitableBuilder<SecretBuildSource, SecretBuildSourceBuilder> {
    SecretBuildSourceFluent<?> fluent;

    public SecretBuildSourceBuilder() {
        this(new SecretBuildSource());
    }

    public SecretBuildSourceBuilder(SecretBuildSourceFluent<?> fluent) {
        this(fluent, new SecretBuildSource());
    }

    public SecretBuildSourceBuilder(SecretBuildSourceFluent<?> fluent, SecretBuildSource instance) {
        this.fluent = fluent;
        fluent.withDestinationDir(instance.getDestinationDir());
        fluent.withSecret(instance.getSecret());
    }

    public SecretBuildSourceBuilder(SecretBuildSource instance) {
        this.fluent = this;
        this.withDestinationDir(instance.getDestinationDir());
        this.withSecret(instance.getSecret());
    }

    @Override
    public SecretBuildSource build() {
        SecretBuildSource buildable = new SecretBuildSource(this.fluent.getDestinationDir(), this.fluent.getSecret());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecretBuildSourceBuilder that = (SecretBuildSourceBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

