/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.SecretSpec;
import io.fabric8.openshift.api.model.SecretSpecFluent;

public class SecretSpecFluentImpl<A extends SecretSpecFluent<A>>
extends BaseFluent<A>
implements SecretSpecFluent<A> {
    String mountPath;
    VisitableBuilder<LocalObjectReference, ?> secretSource;

    public SecretSpecFluentImpl() {
    }

    public SecretSpecFluentImpl(SecretSpec instance) {
        this.withMountPath(instance.getMountPath());
        this.withSecretSource(instance.getSecretSource());
    }

    @Override
    public String getMountPath() {
        return this.mountPath;
    }

    @Override
    public A withMountPath(String mountPath) {
        this.mountPath = mountPath;
        return (A)this;
    }

    @Override
    public LocalObjectReference getSecretSource() {
        return this.secretSource != null ? (LocalObjectReference)this.secretSource.build() : null;
    }

    @Override
    public A withSecretSource(LocalObjectReference secretSource) {
        if (secretSource != null) {
            this.secretSource = new LocalObjectReferenceBuilder(secretSource);
            this._visitables.add(this.secretSource);
        }
        return (A)this;
    }

    @Override
    public SecretSpecFluent.SecretSourceNested<A> withNewSecretSource() {
        return new SecretSourceNestedImpl();
    }

    @Override
    public SecretSpecFluent.SecretSourceNested<A> withNewSecretSourceLike(LocalObjectReference item) {
        return new SecretSourceNestedImpl(item);
    }

    @Override
    public SecretSpecFluent.SecretSourceNested<A> editSecretSource() {
        return this.withNewSecretSourceLike(this.getSecretSource());
    }

    @Override
    public A withNewSecretSource(String name) {
        return this.withSecretSource(new LocalObjectReference(name));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecretSpecFluentImpl that = (SecretSpecFluentImpl)o;
        if (this.mountPath != null ? !this.mountPath.equals(that.mountPath) : that.mountPath != null) {
            return false;
        }
        return !(this.secretSource != null ? !this.secretSource.equals(that.secretSource) : that.secretSource != null);
    }

    public class SecretSourceNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<SecretSpecFluent.SecretSourceNested<N>>
    implements SecretSpecFluent.SecretSourceNested<N> {
        private final LocalObjectReferenceBuilder builder;

        SecretSourceNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        SecretSourceNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N endSecretSource() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)SecretSpecFluentImpl.this.withSecretSource(this.builder.build());
        }
    }
}

