/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.SourceBuildStrategy;
import io.fabric8.openshift.api.model.SourceBuildStrategyFluent;
import java.util.ArrayList;
import java.util.List;

public class SourceBuildStrategyFluentImpl<A extends SourceBuildStrategyFluent<A>>
extends BaseFluent<A>
implements SourceBuildStrategyFluent<A> {
    List<VisitableBuilder<EnvVar, ?>> env = new ArrayList();
    Boolean forcePull;
    VisitableBuilder<ObjectReference, ?> from;
    Boolean incremental;
    VisitableBuilder<LocalObjectReference, ?> pullSecret;
    String scripts;

    public SourceBuildStrategyFluentImpl() {
    }

    public SourceBuildStrategyFluentImpl(SourceBuildStrategy instance) {
        this.withEnv(instance.getEnv());
        this.withForcePull(instance.getForcePull());
        this.withFrom(instance.getFrom());
        this.withIncremental(instance.getIncremental());
        this.withPullSecret(instance.getPullSecret());
        this.withScripts(instance.getScripts());
    }

    @Override
    public A addToEnv(EnvVar ... items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.add(builder);
            this.env.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnv(EnvVar ... items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.remove(builder);
            this.env.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<EnvVar> getEnv() {
        return this.build(this.env);
    }

    @Override
    public A withEnv(List<EnvVar> env) {
        this.env.clear();
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withEnv(EnvVar ... env) {
        this.env.clear();
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    @Override
    public SourceBuildStrategyFluent.EnvNested<A> addNewEnv() {
        return new EnvNestedImpl();
    }

    @Override
    public SourceBuildStrategyFluent.EnvNested<A> addNewEnvLike(EnvVar item) {
        return new EnvNestedImpl(item);
    }

    @Override
    public Boolean isForcePull() {
        return this.forcePull;
    }

    @Override
    public A withForcePull(Boolean forcePull) {
        this.forcePull = forcePull;
        return (A)this;
    }

    @Override
    public ObjectReference getFrom() {
        return this.from != null ? (ObjectReference)this.from.build() : null;
    }

    @Override
    public A withFrom(ObjectReference from) {
        if (from != null) {
            this.from = new ObjectReferenceBuilder(from);
            this._visitables.add(this.from);
        }
        return (A)this;
    }

    @Override
    public SourceBuildStrategyFluent.FromNested<A> withNewFrom() {
        return new FromNestedImpl();
    }

    @Override
    public SourceBuildStrategyFluent.FromNested<A> withNewFromLike(ObjectReference item) {
        return new FromNestedImpl(item);
    }

    @Override
    public SourceBuildStrategyFluent.FromNested<A> editFrom() {
        return this.withNewFromLike(this.getFrom());
    }

    @Override
    public Boolean isIncremental() {
        return this.incremental;
    }

    @Override
    public A withIncremental(Boolean incremental) {
        this.incremental = incremental;
        return (A)this;
    }

    @Override
    public LocalObjectReference getPullSecret() {
        return this.pullSecret != null ? (LocalObjectReference)this.pullSecret.build() : null;
    }

    @Override
    public A withPullSecret(LocalObjectReference pullSecret) {
        if (pullSecret != null) {
            this.pullSecret = new LocalObjectReferenceBuilder(pullSecret);
            this._visitables.add(this.pullSecret);
        }
        return (A)this;
    }

    @Override
    public SourceBuildStrategyFluent.PullSecretNested<A> withNewPullSecret() {
        return new PullSecretNestedImpl();
    }

    @Override
    public SourceBuildStrategyFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item) {
        return new PullSecretNestedImpl(item);
    }

    @Override
    public SourceBuildStrategyFluent.PullSecretNested<A> editPullSecret() {
        return this.withNewPullSecretLike(this.getPullSecret());
    }

    @Override
    public A withNewPullSecret(String name) {
        return this.withPullSecret(new LocalObjectReference(name));
    }

    @Override
    public String getScripts() {
        return this.scripts;
    }

    @Override
    public A withScripts(String scripts) {
        this.scripts = scripts;
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceBuildStrategyFluentImpl that = (SourceBuildStrategyFluentImpl)o;
        if (this.env != null ? !this.env.equals(that.env) : that.env != null) {
            return false;
        }
        if (this.forcePull != null ? !this.forcePull.equals(that.forcePull) : that.forcePull != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        if (this.incremental != null ? !this.incremental.equals(that.incremental) : that.incremental != null) {
            return false;
        }
        if (this.pullSecret != null ? !this.pullSecret.equals(that.pullSecret) : that.pullSecret != null) {
            return false;
        }
        return !(this.scripts != null ? !this.scripts.equals(that.scripts) : that.scripts != null);
    }

    public class PullSecretNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<SourceBuildStrategyFluent.PullSecretNested<N>>
    implements SourceBuildStrategyFluent.PullSecretNested<N> {
        private final LocalObjectReferenceBuilder builder;

        PullSecretNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        PullSecretNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SourceBuildStrategyFluentImpl.this.withPullSecret(this.builder.build());
        }

        @Override
        public N endPullSecret() {
            return this.and();
        }
    }

    public class FromNestedImpl<N>
    extends ObjectReferenceFluentImpl<SourceBuildStrategyFluent.FromNested<N>>
    implements SourceBuildStrategyFluent.FromNested<N> {
        private final ObjectReferenceBuilder builder;

        FromNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        FromNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N endFrom() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)SourceBuildStrategyFluentImpl.this.withFrom(this.builder.build());
        }
    }

    public class EnvNestedImpl<N>
    extends EnvVarFluentImpl<SourceBuildStrategyFluent.EnvNested<N>>
    implements SourceBuildStrategyFluent.EnvNested<N> {
        private final EnvVarBuilder builder;

        EnvNestedImpl() {
            this.builder = new EnvVarBuilder(this);
        }

        EnvNestedImpl(EnvVar item) {
            this.builder = new EnvVarBuilder(this, item);
        }

        @Override
        public N endEnv() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)SourceBuildStrategyFluentImpl.this.addToEnv(this.builder.build());
        }
    }
}

