/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.EditableTemplate;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateFluent;
import io.fabric8.openshift.api.model.TemplateFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class TemplateBuilder
extends TemplateFluentImpl<TemplateBuilder>
implements VisitableBuilder<Template, TemplateBuilder> {
    TemplateFluent<?> fluent;

    public TemplateBuilder() {
        this(new Template());
    }

    public TemplateBuilder(TemplateFluent<?> fluent) {
        this(fluent, new Template());
    }

    public TemplateBuilder(TemplateFluent<?> fluent, Template instance) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withLabels(instance.getLabels());
        fluent.withMetadata(instance.getMetadata());
        fluent.withObjects(instance.getObjects());
        fluent.withParameters(instance.getParameters());
    }

    public TemplateBuilder(Template instance) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withLabels(instance.getLabels());
        this.withMetadata(instance.getMetadata());
        this.withObjects(instance.getObjects());
        this.withParameters(instance.getParameters());
    }

    @Override
    public EditableTemplate build() {
        EditableTemplate buildable = new EditableTemplate(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getLabels(), this.fluent.getMetadata(), this.fluent.getObjects(), this.fluent.getParameters());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TemplateBuilder that = (TemplateBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

