package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class DeleteOptionsFluentImpl<T extends DeleteOptionsFluent<T>> extends BaseFluent<T> implements DeleteOptionsFluent<T>{

     String apiVersion;     Long gracePeriodSeconds;     String kind;     VisitableBuilder<Preconditions, ?> preconditions;     Map<String, Object> additionalProperties = new HashMap();
public DeleteOptionsFluentImpl(){
    
}
public DeleteOptionsFluentImpl( DeleteOptions instance ){
    this.withApiVersion(instance.getApiVersion()); this.withGracePeriodSeconds(instance.getGracePeriodSeconds()); this.withKind(instance.getKind()); this.withPreconditions(instance.getPreconditions()); 
}

    public String getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public Long getGracePeriodSeconds(){
    return this.gracePeriodSeconds;
    }
    public T withGracePeriodSeconds( Long gracePeriodSeconds){
    this.gracePeriodSeconds=gracePeriodSeconds; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public Preconditions getPreconditions(){
    return this.preconditions!=null?this.preconditions.build():null;
    }
    public T withPreconditions( Preconditions preconditions){
    if (preconditions!=null){ this.preconditions= new PreconditionsBuilder(preconditions); _visitables.add(this.preconditions);} return (T) this;
    }
    public PreconditionsNested<T> withNewPreconditions(){
    return new PreconditionsNestedImpl<T>();
    }
    public PreconditionsNested<T> withNewPreconditionsLike( Preconditions item){
    return new PreconditionsNestedImpl<T>(item);
    }
    public PreconditionsNested<T> editPreconditions(){
    return withNewPreconditionsLike(getPreconditions());
    }
    public T withNewPreconditions( String uid){
    return withPreconditions(new Preconditions(uid));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
DeleteOptionsFluentImpl that = (DeleteOptionsFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (gracePeriodSeconds != null ? !gracePeriodSeconds.equals(that.gracePeriodSeconds) :that.gracePeriodSeconds != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (preconditions != null ? !preconditions.equals(that.preconditions) :that.preconditions != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class PreconditionsNestedImpl<N> extends PreconditionsFluentImpl<PreconditionsNested<N>> implements PreconditionsNested<N>{

        private final PreconditionsBuilder builder;
    
             PreconditionsNestedImpl (){
        this.builder = new PreconditionsBuilder(this);
        }
             PreconditionsNestedImpl ( Preconditions item){
        this.builder = new PreconditionsBuilder(this, item);
        }
    
            public N and(){
            return (N) DeleteOptionsFluentImpl.this.withPreconditions(builder.build());
        }
            public N endPreconditions(){
            return and();
        }
    
}


}
