package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class HandlerBuilder extends HandlerFluentImpl<HandlerBuilder> implements VisitableBuilder<Handler,HandlerBuilder>{

     HandlerFluent<?> fluent;
public HandlerBuilder(){
    this(new Handler());
}
public HandlerBuilder( HandlerFluent<?> fluent ){
    this(fluent, new Handler());
}
public HandlerBuilder( HandlerFluent<?> fluent , Handler instance ){
    this.fluent = fluent; fluent.withExec(instance.getExec()); fluent.withHttpGet(instance.getHttpGet()); fluent.withTcpSocket(instance.getTcpSocket()); 
}
public HandlerBuilder( Handler instance ){
    this.fluent = this; this.withExec(instance.getExec()); this.withHttpGet(instance.getHttpGet()); this.withTcpSocket(instance.getTcpSocket()); 
}

public Handler build(){
    Handler buildable = new Handler(fluent.getExec(),fluent.getHttpGet(),fluent.getTcpSocket());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
HandlerBuilder that = (HandlerBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
