package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class LoadBalancerIngressFluentImpl<T extends LoadBalancerIngressFluent<T>> extends BaseFluent<T> implements LoadBalancerIngressFluent<T>{

     String hostname;     String ip;     Map<String, Object> additionalProperties = new HashMap();
public LoadBalancerIngressFluentImpl(){
    
}
public LoadBalancerIngressFluentImpl( LoadBalancerIngress instance ){
    this.withHostname(instance.getHostname()); this.withIp(instance.getIp()); 
}

    public String getHostname(){
    return this.hostname;
    }
    public T withHostname( String hostname){
    this.hostname=hostname; return (T) this;
    }
    public String getIp(){
    return this.ip;
    }
    public T withIp( String ip){
    this.ip=ip; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
LoadBalancerIngressFluentImpl that = (LoadBalancerIngressFluentImpl) o;
if (hostname != null ? !hostname.equals(that.hostname) :that.hostname != null) return false;
if (ip != null ? !ip.equals(that.ip) :that.ip != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
