package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class DaemonSetSpecBuilder extends DaemonSetSpecFluentImpl<DaemonSetSpecBuilder> implements VisitableBuilder<DaemonSetSpec,DaemonSetSpecBuilder>{

     DaemonSetSpecFluent<?> fluent;
public DaemonSetSpecBuilder(){
    this(new DaemonSetSpec());
}
public DaemonSetSpecBuilder( DaemonSetSpecFluent<?> fluent ){
    this(fluent, new DaemonSetSpec());
}
public DaemonSetSpecBuilder( DaemonSetSpecFluent<?> fluent , DaemonSetSpec instance ){
    this.fluent = fluent; fluent.withSelector(instance.getSelector()); fluent.withTemplate(instance.getTemplate()); 
}
public DaemonSetSpecBuilder( DaemonSetSpec instance ){
    this.fluent = this; this.withSelector(instance.getSelector()); this.withTemplate(instance.getTemplate()); 
}

public DaemonSetSpec build(){
    DaemonSetSpec buildable = new DaemonSetSpec(fluent.getSelector(),fluent.getTemplate());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
DaemonSetSpecBuilder that = (DaemonSetSpecBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
