package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.RandomAccess;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class BuildConfigSpecFluentImpl<T extends BuildConfigSpecFluent<T>> extends BaseFluent<T> implements BuildConfigSpecFluent<T>{

     Long completionDeadlineSeconds;     VisitableBuilder<BuildOutput, ?> output;     VisitableBuilder<BuildPostCommitSpec, ?> postCommit;     VisitableBuilder<ResourceRequirements, ?> resources;     VisitableBuilder<SourceRevision, ?> revision;     String runPolicy;     String serviceAccount;     VisitableBuilder<BuildSource, ?> source;     VisitableBuilder<BuildStrategy, ?> strategy;     List<VisitableBuilder<BuildTriggerPolicy, ?>> triggers = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();
public BuildConfigSpecFluentImpl(){
    
}
public BuildConfigSpecFluentImpl( BuildConfigSpec instance ){
    this.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds()); this.withOutput(instance.getOutput()); this.withPostCommit(instance.getPostCommit()); this.withResources(instance.getResources()); this.withRevision(instance.getRevision()); this.withRunPolicy(instance.getRunPolicy()); this.withServiceAccount(instance.getServiceAccount()); this.withSource(instance.getSource()); this.withStrategy(instance.getStrategy()); this.withTriggers(instance.getTriggers()); 
}

    public Long getCompletionDeadlineSeconds(){
    return this.completionDeadlineSeconds;
    }
    public T withCompletionDeadlineSeconds( Long completionDeadlineSeconds){
    this.completionDeadlineSeconds=completionDeadlineSeconds; return (T) this;
    }
    public BuildOutput getOutput(){
    return this.output!=null?this.output.build():null;
    }
    public T withOutput( BuildOutput output){
    if (output!=null){ this.output= new BuildOutputBuilder(output); _visitables.add(this.output);} return (T) this;
    }
    public OutputNested<T> withNewOutput(){
    return new OutputNestedImpl<T>();
    }
    public OutputNested<T> withNewOutputLike( BuildOutput item){
    return new OutputNestedImpl<T>(item);
    }
    public OutputNested<T> editOutput(){
    return withNewOutputLike(getOutput());
    }
    public BuildPostCommitSpec getPostCommit(){
    return this.postCommit!=null?this.postCommit.build():null;
    }
    public T withPostCommit( BuildPostCommitSpec postCommit){
    if (postCommit!=null){ this.postCommit= new BuildPostCommitSpecBuilder(postCommit); _visitables.add(this.postCommit);} return (T) this;
    }
    public PostCommitNested<T> withNewPostCommit(){
    return new PostCommitNestedImpl<T>();
    }
    public PostCommitNested<T> withNewPostCommitLike( BuildPostCommitSpec item){
    return new PostCommitNestedImpl<T>(item);
    }
    public PostCommitNested<T> editPostCommit(){
    return withNewPostCommitLike(getPostCommit());
    }
    public ResourceRequirements getResources(){
    return this.resources!=null?this.resources.build():null;
    }
    public T withResources( ResourceRequirements resources){
    if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.add(this.resources);} return (T) this;
    }
    public ResourcesNested<T> withNewResources(){
    return new ResourcesNestedImpl<T>();
    }
    public ResourcesNested<T> withNewResourcesLike( ResourceRequirements item){
    return new ResourcesNestedImpl<T>(item);
    }
    public ResourcesNested<T> editResources(){
    return withNewResourcesLike(getResources());
    }
    public SourceRevision getRevision(){
    return this.revision!=null?this.revision.build():null;
    }
    public T withRevision( SourceRevision revision){
    if (revision!=null){ this.revision= new SourceRevisionBuilder(revision); _visitables.add(this.revision);} return (T) this;
    }
    public RevisionNested<T> withNewRevision(){
    return new RevisionNestedImpl<T>();
    }
    public RevisionNested<T> withNewRevisionLike( SourceRevision item){
    return new RevisionNestedImpl<T>(item);
    }
    public RevisionNested<T> editRevision(){
    return withNewRevisionLike(getRevision());
    }
    public String getRunPolicy(){
    return this.runPolicy;
    }
    public T withRunPolicy( String runPolicy){
    this.runPolicy=runPolicy; return (T) this;
    }
    public String getServiceAccount(){
    return this.serviceAccount;
    }
    public T withServiceAccount( String serviceAccount){
    this.serviceAccount=serviceAccount; return (T) this;
    }
    public BuildSource getSource(){
    return this.source!=null?this.source.build():null;
    }
    public T withSource( BuildSource source){
    if (source!=null){ this.source= new BuildSourceBuilder(source); _visitables.add(this.source);} return (T) this;
    }
    public SourceNested<T> withNewSource(){
    return new SourceNestedImpl<T>();
    }
    public SourceNested<T> withNewSourceLike( BuildSource item){
    return new SourceNestedImpl<T>(item);
    }
    public SourceNested<T> editSource(){
    return withNewSourceLike(getSource());
    }
    public BuildStrategy getStrategy(){
    return this.strategy!=null?this.strategy.build():null;
    }
    public T withStrategy( BuildStrategy strategy){
    if (strategy!=null){ this.strategy= new BuildStrategyBuilder(strategy); _visitables.add(this.strategy);} return (T) this;
    }
    public StrategyNested<T> withNewStrategy(){
    return new StrategyNestedImpl<T>();
    }
    public StrategyNested<T> withNewStrategyLike( BuildStrategy item){
    return new StrategyNestedImpl<T>(item);
    }
    public StrategyNested<T> editStrategy(){
    return withNewStrategyLike(getStrategy());
    }
    public T addToTriggers( BuildTriggerPolicy ...items){
    for (BuildTriggerPolicy item : items) {BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);_visitables.add(builder);this.triggers.add(builder);} return (T)this;
    }
    public T removeFromTriggers( BuildTriggerPolicy ...items){
    for (BuildTriggerPolicy item : items) {BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);_visitables.remove(builder);this.triggers.remove(builder);} return (T)this;
    }
    public List<BuildTriggerPolicy> getTriggers(){
    return build(triggers);
    }
    public T withTriggers( List<BuildTriggerPolicy> triggers){
    this.triggers.clear();if (triggers != null) {for (BuildTriggerPolicy item : triggers){this.addToTriggers(item);}} return (T) this;
    }
    public T withTriggers( BuildTriggerPolicy ...triggers){
    this.triggers.clear(); if (triggers != null) {for (BuildTriggerPolicy item :triggers){ this.addToTriggers(item);}} return (T) this;
    }
    public TriggersNested<T> addNewTrigger(){
    return new TriggersNestedImpl<T>();
    }
    public TriggersNested<T> addNewTriggerLike( BuildTriggerPolicy item){
    return new TriggersNestedImpl<T>(item);
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
BuildConfigSpecFluentImpl that = (BuildConfigSpecFluentImpl) o;
if (completionDeadlineSeconds != null ? !completionDeadlineSeconds.equals(that.completionDeadlineSeconds) :that.completionDeadlineSeconds != null) return false;
if (output != null ? !output.equals(that.output) :that.output != null) return false;
if (postCommit != null ? !postCommit.equals(that.postCommit) :that.postCommit != null) return false;
if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
if (revision != null ? !revision.equals(that.revision) :that.revision != null) return false;
if (runPolicy != null ? !runPolicy.equals(that.runPolicy) :that.runPolicy != null) return false;
if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
if (source != null ? !source.equals(that.source) :that.source != null) return false;
if (strategy != null ? !strategy.equals(that.strategy) :that.strategy != null) return false;
if (triggers != null ? !triggers.equals(that.triggers) :that.triggers != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class OutputNestedImpl<N> extends BuildOutputFluentImpl<OutputNested<N>> implements OutputNested<N>{

        private final BuildOutputBuilder builder;
    
             OutputNestedImpl (){
        this.builder = new BuildOutputBuilder(this);
        }
             OutputNestedImpl ( BuildOutput item){
        this.builder = new BuildOutputBuilder(this, item);
        }
    
            public N endOutput(){
            return and();
        }
            public N and(){
            return (N) BuildConfigSpecFluentImpl.this.withOutput(builder.build());
        }
    
}
    public class PostCommitNestedImpl<N> extends BuildPostCommitSpecFluentImpl<PostCommitNested<N>> implements PostCommitNested<N>{

        private final BuildPostCommitSpecBuilder builder;
    
             PostCommitNestedImpl (){
        this.builder = new BuildPostCommitSpecBuilder(this);
        }
             PostCommitNestedImpl ( BuildPostCommitSpec item){
        this.builder = new BuildPostCommitSpecBuilder(this, item);
        }
    
            public N and(){
            return (N) BuildConfigSpecFluentImpl.this.withPostCommit(builder.build());
        }
            public N endPostCommit(){
            return and();
        }
    
}
    public class ResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<ResourcesNested<N>> implements ResourcesNested<N>{

        private final ResourceRequirementsBuilder builder;
    
             ResourcesNestedImpl (){
        this.builder = new ResourceRequirementsBuilder(this);
        }
             ResourcesNestedImpl ( ResourceRequirements item){
        this.builder = new ResourceRequirementsBuilder(this, item);
        }
    
            public N and(){
            return (N) BuildConfigSpecFluentImpl.this.withResources(builder.build());
        }
            public N endResources(){
            return and();
        }
    
}
    public class RevisionNestedImpl<N> extends SourceRevisionFluentImpl<RevisionNested<N>> implements RevisionNested<N>{

        private final SourceRevisionBuilder builder;
    
             RevisionNestedImpl (){
        this.builder = new SourceRevisionBuilder(this);
        }
             RevisionNestedImpl ( SourceRevision item){
        this.builder = new SourceRevisionBuilder(this, item);
        }
    
            public N endRevision(){
            return and();
        }
            public N and(){
            return (N) BuildConfigSpecFluentImpl.this.withRevision(builder.build());
        }
    
}
    public class SourceNestedImpl<N> extends BuildSourceFluentImpl<SourceNested<N>> implements SourceNested<N>{

        private final BuildSourceBuilder builder;
    
             SourceNestedImpl (){
        this.builder = new BuildSourceBuilder(this);
        }
             SourceNestedImpl ( BuildSource item){
        this.builder = new BuildSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) BuildConfigSpecFluentImpl.this.withSource(builder.build());
        }
            public N endSource(){
            return and();
        }
    
}
    public class StrategyNestedImpl<N> extends BuildStrategyFluentImpl<StrategyNested<N>> implements StrategyNested<N>{

        private final BuildStrategyBuilder builder;
    
             StrategyNestedImpl (){
        this.builder = new BuildStrategyBuilder(this);
        }
             StrategyNestedImpl ( BuildStrategy item){
        this.builder = new BuildStrategyBuilder(this, item);
        }
    
            public N endStrategy(){
            return and();
        }
            public N and(){
            return (N) BuildConfigSpecFluentImpl.this.withStrategy(builder.build());
        }
    
}
    public class TriggersNestedImpl<N> extends BuildTriggerPolicyFluentImpl<TriggersNested<N>> implements TriggersNested<N>{

        private final BuildTriggerPolicyBuilder builder;
    
             TriggersNestedImpl (){
        this.builder = new BuildTriggerPolicyBuilder(this);
        }
             TriggersNestedImpl ( BuildTriggerPolicy item){
        this.builder = new BuildTriggerPolicyBuilder(this, item);
        }
    
            public N endTrigger(){
            return and();
        }
            public N and(){
            return (N) BuildConfigSpecFluentImpl.this.addToTriggers(builder.build());
        }
    
}


}
