package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class ClusterRoleScopeRestrictionFluentImpl<T extends ClusterRoleScopeRestrictionFluent<T>> extends BaseFluent<T> implements ClusterRoleScopeRestrictionFluent<T>{

     Boolean allowEscalation;     List<String> namespaces = new ArrayList();     List<String> roleNames = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();
public ClusterRoleScopeRestrictionFluentImpl(){
    
}
public ClusterRoleScopeRestrictionFluentImpl( ClusterRoleScopeRestriction instance ){
    this.withAllowEscalation(instance.getAllowEscalation()); this.withNamespaces(instance.getNamespaces()); this.withRoleNames(instance.getRoleNames()); 
}

    public Boolean isAllowEscalation(){
    return this.allowEscalation;
    }
    public T withAllowEscalation( Boolean allowEscalation){
    this.allowEscalation=allowEscalation; return (T) this;
    }
    public T addToNamespaces( String ...items){
    for (String item : items) {this.namespaces.add(item);} return (T)this;
    }
    public T removeFromNamespaces( String ...items){
    for (String item : items) {this.namespaces.remove(item);} return (T)this;
    }
    public List<String> getNamespaces(){
    return this.namespaces;
    }
    public T withNamespaces( List<String> namespaces){
    this.namespaces.clear();if (namespaces != null) {for (String item : namespaces){this.addToNamespaces(item);}} return (T) this;
    }
    public T withNamespaces( String ...namespaces){
    this.namespaces.clear(); if (namespaces != null) {for (String item :namespaces){ this.addToNamespaces(item);}} return (T) this;
    }
    public T addToRoleNames( String ...items){
    for (String item : items) {this.roleNames.add(item);} return (T)this;
    }
    public T removeFromRoleNames( String ...items){
    for (String item : items) {this.roleNames.remove(item);} return (T)this;
    }
    public List<String> getRoleNames(){
    return this.roleNames;
    }
    public T withRoleNames( List<String> roleNames){
    this.roleNames.clear();if (roleNames != null) {for (String item : roleNames){this.addToRoleNames(item);}} return (T) this;
    }
    public T withRoleNames( String ...roleNames){
    this.roleNames.clear(); if (roleNames != null) {for (String item :roleNames){ this.addToRoleNames(item);}} return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ClusterRoleScopeRestrictionFluentImpl that = (ClusterRoleScopeRestrictionFluentImpl) o;
if (allowEscalation != null ? !allowEscalation.equals(that.allowEscalation) :that.allowEscalation != null) return false;
if (namespaces != null ? !namespaces.equals(that.namespaces) :that.namespaces != null) return false;
if (roleNames != null ? !roleNames.equals(that.roleNames) :that.roleNames != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
