package io.fabric8.openshift.api.model;

import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class DeploymentConfigStatusFluentImpl<T extends DeploymentConfigStatusFluent<T>> extends BaseFluent<T> implements DeploymentConfigStatusFluent<T>{

     VisitableBuilder<DeploymentDetails, ?> details;     Integer latestVersion;     Long observedGeneration;     Map<String, Object> additionalProperties = new HashMap();
public DeploymentConfigStatusFluentImpl(){
    
}
public DeploymentConfigStatusFluentImpl( DeploymentConfigStatus instance ){
    this.withDetails(instance.getDetails()); this.withLatestVersion(instance.getLatestVersion()); this.withObservedGeneration(instance.getObservedGeneration()); 
}

    public DeploymentDetails getDetails(){
    return this.details!=null?this.details.build():null;
    }
    public T withDetails( DeploymentDetails details){
    if (details!=null){ this.details= new DeploymentDetailsBuilder(details); _visitables.add(this.details);} return (T) this;
    }
    public DetailsNested<T> withNewDetails(){
    return new DetailsNestedImpl<T>();
    }
    public DetailsNested<T> withNewDetailsLike( DeploymentDetails item){
    return new DetailsNestedImpl<T>(item);
    }
    public DetailsNested<T> editDetails(){
    return withNewDetailsLike(getDetails());
    }
    public Integer getLatestVersion(){
    return this.latestVersion;
    }
    public T withLatestVersion( Integer latestVersion){
    this.latestVersion=latestVersion; return (T) this;
    }
    public Long getObservedGeneration(){
    return this.observedGeneration;
    }
    public T withObservedGeneration( Long observedGeneration){
    this.observedGeneration=observedGeneration; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
DeploymentConfigStatusFluentImpl that = (DeploymentConfigStatusFluentImpl) o;
if (details != null ? !details.equals(that.details) :that.details != null) return false;
if (latestVersion != null ? !latestVersion.equals(that.latestVersion) :that.latestVersion != null) return false;
if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class DetailsNestedImpl<N> extends DeploymentDetailsFluentImpl<DetailsNested<N>> implements DetailsNested<N>{

        private final DeploymentDetailsBuilder builder;
    
             DetailsNestedImpl (){
        this.builder = new DeploymentDetailsBuilder(this);
        }
             DetailsNestedImpl ( DeploymentDetails item){
        this.builder = new DeploymentDetailsBuilder(this, item);
        }
    
            public N and(){
            return (N) DeploymentConfigStatusFluentImpl.this.withDetails(builder.build());
        }
            public N endDetails(){
            return and();
        }
    
}


}
