package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.List;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.List;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;

public class ImageSourceFluentImpl<T extends ImageSourceFluent<T>> extends BaseFluent<T> implements ImageSourceFluent<T>{

     VisitableBuilder<ObjectReference, ?> from;     List<VisitableBuilder<ImageSourcePath, ?>> paths = new ArrayList();     VisitableBuilder<LocalObjectReference, ?> pullSecret;     Map<String, Object> additionalProperties = new HashMap();
public ImageSourceFluentImpl(){
    
}
public ImageSourceFluentImpl( ImageSource instance ){
    this.withFrom(instance.getFrom()); this.withPaths(instance.getPaths()); this.withPullSecret(instance.getPullSecret()); 
}

    public ObjectReference getFrom(){
    return this.from!=null?this.from.build():null;
    }
    public T withFrom( ObjectReference from){
    if (from!=null){ this.from= new ObjectReferenceBuilder(from); _visitables.add(this.from);} return (T) this;
    }
    public FromNested<T> withNewFrom(){
    return new FromNestedImpl<T>();
    }
    public FromNested<T> withNewFromLike( ObjectReference item){
    return new FromNestedImpl<T>(item);
    }
    public FromNested<T> editFrom(){
    return withNewFromLike(getFrom());
    }
    public T addToPaths( ImageSourcePath ...items){
    for (ImageSourcePath item : items) {ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);_visitables.add(builder);this.paths.add(builder);} return (T)this;
    }
    public T removeFromPaths( ImageSourcePath ...items){
    for (ImageSourcePath item : items) {ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);_visitables.remove(builder);this.paths.remove(builder);} return (T)this;
    }
    public List<ImageSourcePath> getPaths(){
    return build(paths);
    }
    public T withPaths( List<ImageSourcePath> paths){
    this.paths.clear();if (paths != null) {for (ImageSourcePath item : paths){this.addToPaths(item);}} return (T) this;
    }
    public T withPaths( ImageSourcePath ...paths){
    this.paths.clear(); if (paths != null) {for (ImageSourcePath item :paths){ this.addToPaths(item);}} return (T) this;
    }
    public PathsNested<T> addNewPath(){
    return new PathsNestedImpl<T>();
    }
    public PathsNested<T> addNewPathLike( ImageSourcePath item){
    return new PathsNestedImpl<T>(item);
    }
    public T addNewPath( String destinationDir,  String sourcePath){
    return addToPaths(new ImageSourcePath(destinationDir, sourcePath));
    }
    public LocalObjectReference getPullSecret(){
    return this.pullSecret!=null?this.pullSecret.build():null;
    }
    public T withPullSecret( LocalObjectReference pullSecret){
    if (pullSecret!=null){ this.pullSecret= new LocalObjectReferenceBuilder(pullSecret); _visitables.add(this.pullSecret);} return (T) this;
    }
    public PullSecretNested<T> withNewPullSecret(){
    return new PullSecretNestedImpl<T>();
    }
    public PullSecretNested<T> withNewPullSecretLike( LocalObjectReference item){
    return new PullSecretNestedImpl<T>(item);
    }
    public PullSecretNested<T> editPullSecret(){
    return withNewPullSecretLike(getPullSecret());
    }
    public T withNewPullSecret( String name){
    return withPullSecret(new LocalObjectReference(name));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ImageSourceFluentImpl that = (ImageSourceFluentImpl) o;
if (from != null ? !from.equals(that.from) :that.from != null) return false;
if (paths != null ? !paths.equals(that.paths) :that.paths != null) return false;
if (pullSecret != null ? !pullSecret.equals(that.pullSecret) :that.pullSecret != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class FromNestedImpl<N> extends ObjectReferenceFluentImpl<FromNested<N>> implements FromNested<N>{

        private final ObjectReferenceBuilder builder;
    
             FromNestedImpl (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             FromNestedImpl ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N endFrom(){
            return and();
        }
            public N and(){
            return (N) ImageSourceFluentImpl.this.withFrom(builder.build());
        }
    
}
    public class PathsNestedImpl<N> extends ImageSourcePathFluentImpl<PathsNested<N>> implements PathsNested<N>{

        private final ImageSourcePathBuilder builder;
    
             PathsNestedImpl (){
        this.builder = new ImageSourcePathBuilder(this);
        }
             PathsNestedImpl ( ImageSourcePath item){
        this.builder = new ImageSourcePathBuilder(this, item);
        }
    
            public N and(){
            return (N) ImageSourceFluentImpl.this.addToPaths(builder.build());
        }
            public N endPath(){
            return and();
        }
    
}
    public class PullSecretNestedImpl<N> extends LocalObjectReferenceFluentImpl<PullSecretNested<N>> implements PullSecretNested<N>{

        private final LocalObjectReferenceBuilder builder;
    
             PullSecretNestedImpl (){
        this.builder = new LocalObjectReferenceBuilder(this);
        }
             PullSecretNestedImpl ( LocalObjectReference item){
        this.builder = new LocalObjectReferenceBuilder(this, item);
        }
    
            public N and(){
            return (N) ImageSourceFluentImpl.this.withPullSecret(builder.build());
        }
            public N endPullSecret(){
            return and();
        }
    
}


}
