package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import java.util.List;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;

public class OAuthClientFluentImpl<T extends OAuthClientFluent<T>> extends BaseFluent<T> implements OAuthClientFluent<T>{

     List<String> additionalSecrets = new ArrayList();     String apiVersion;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     List<String> redirectURIs = new ArrayList();     Boolean respondWithChallenges;     List<VisitableBuilder<ScopeRestriction, ?>> scopeRestrictions = new ArrayList();     String secret;     Map<String, Object> additionalProperties = new HashMap();
public OAuthClientFluentImpl(){
    
}
public OAuthClientFluentImpl( OAuthClient instance ){
    this.withAdditionalSecrets(instance.getAdditionalSecrets()); this.withApiVersion(instance.getApiVersion()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withRedirectURIs(instance.getRedirectURIs()); this.withRespondWithChallenges(instance.getRespondWithChallenges()); this.withScopeRestrictions(instance.getScopeRestrictions()); this.withSecret(instance.getSecret()); 
}

    public T addToAdditionalSecrets( String ...items){
    for (String item : items) {this.additionalSecrets.add(item);} return (T)this;
    }
    public T removeFromAdditionalSecrets( String ...items){
    for (String item : items) {this.additionalSecrets.remove(item);} return (T)this;
    }
    public List<String> getAdditionalSecrets(){
    return this.additionalSecrets;
    }
    public T withAdditionalSecrets( List<String> additionalSecrets){
    this.additionalSecrets.clear();if (additionalSecrets != null) {for (String item : additionalSecrets){this.addToAdditionalSecrets(item);}} return (T) this;
    }
    public T withAdditionalSecrets( String ...additionalSecrets){
    this.additionalSecrets.clear(); if (additionalSecrets != null) {for (String item :additionalSecrets){ this.addToAdditionalSecrets(item);}} return (T) this;
    }
    public String getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNestedImpl<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public T addToRedirectURIs( String ...items){
    for (String item : items) {this.redirectURIs.add(item);} return (T)this;
    }
    public T removeFromRedirectURIs( String ...items){
    for (String item : items) {this.redirectURIs.remove(item);} return (T)this;
    }
    public List<String> getRedirectURIs(){
    return this.redirectURIs;
    }
    public T withRedirectURIs( List<String> redirectURIs){
    this.redirectURIs.clear();if (redirectURIs != null) {for (String item : redirectURIs){this.addToRedirectURIs(item);}} return (T) this;
    }
    public T withRedirectURIs( String ...redirectURIs){
    this.redirectURIs.clear(); if (redirectURIs != null) {for (String item :redirectURIs){ this.addToRedirectURIs(item);}} return (T) this;
    }
    public Boolean isRespondWithChallenges(){
    return this.respondWithChallenges;
    }
    public T withRespondWithChallenges( Boolean respondWithChallenges){
    this.respondWithChallenges=respondWithChallenges; return (T) this;
    }
    public T addToScopeRestrictions( ScopeRestriction ...items){
    for (ScopeRestriction item : items) {ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);_visitables.add(builder);this.scopeRestrictions.add(builder);} return (T)this;
    }
    public T removeFromScopeRestrictions( ScopeRestriction ...items){
    for (ScopeRestriction item : items) {ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);_visitables.remove(builder);this.scopeRestrictions.remove(builder);} return (T)this;
    }
    public List<ScopeRestriction> getScopeRestrictions(){
    return build(scopeRestrictions);
    }
    public T withScopeRestrictions( List<ScopeRestriction> scopeRestrictions){
    this.scopeRestrictions.clear();if (scopeRestrictions != null) {for (ScopeRestriction item : scopeRestrictions){this.addToScopeRestrictions(item);}} return (T) this;
    }
    public T withScopeRestrictions( ScopeRestriction ...scopeRestrictions){
    this.scopeRestrictions.clear(); if (scopeRestrictions != null) {for (ScopeRestriction item :scopeRestrictions){ this.addToScopeRestrictions(item);}} return (T) this;
    }
    public ScopeRestrictionsNested<T> addNewScopeRestriction(){
    return new ScopeRestrictionsNestedImpl<T>();
    }
    public ScopeRestrictionsNested<T> addNewScopeRestrictionLike( ScopeRestriction item){
    return new ScopeRestrictionsNestedImpl<T>(item);
    }
    public String getSecret(){
    return this.secret;
    }
    public T withSecret( String secret){
    this.secret=secret; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
OAuthClientFluentImpl that = (OAuthClientFluentImpl) o;
if (additionalSecrets != null ? !additionalSecrets.equals(that.additionalSecrets) :that.additionalSecrets != null) return false;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (redirectURIs != null ? !redirectURIs.equals(that.redirectURIs) :that.redirectURIs != null) return false;
if (respondWithChallenges != null ? !respondWithChallenges.equals(that.respondWithChallenges) :that.respondWithChallenges != null) return false;
if (scopeRestrictions != null ? !scopeRestrictions.equals(that.scopeRestrictions) :that.scopeRestrictions != null) return false;
if (secret != null ? !secret.equals(that.secret) :that.secret != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N and(){
            return (N) OAuthClientFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class ScopeRestrictionsNestedImpl<N> extends ScopeRestrictionFluentImpl<ScopeRestrictionsNested<N>> implements ScopeRestrictionsNested<N>{

        private final ScopeRestrictionBuilder builder;
    
             ScopeRestrictionsNestedImpl (){
        this.builder = new ScopeRestrictionBuilder(this);
        }
             ScopeRestrictionsNestedImpl ( ScopeRestriction item){
        this.builder = new ScopeRestrictionBuilder(this, item);
        }
    
            public N endScopeRestriction(){
            return and();
        }
            public N and(){
            return (N) OAuthClientFluentImpl.this.addToScopeRestrictions(builder.build());
        }
    
}


}
