package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class SecretSpecFluentImpl<T extends SecretSpecFluent<T>> extends BaseFluent<T> implements SecretSpecFluent<T>{

     String mountPath;     VisitableBuilder<LocalObjectReference, ?> secretSource;     Map<String, Object> additionalProperties = new HashMap();
public SecretSpecFluentImpl(){
    
}
public SecretSpecFluentImpl( SecretSpec instance ){
    this.withMountPath(instance.getMountPath()); this.withSecretSource(instance.getSecretSource()); 
}

    public String getMountPath(){
    return this.mountPath;
    }
    public T withMountPath( String mountPath){
    this.mountPath=mountPath; return (T) this;
    }
    public LocalObjectReference getSecretSource(){
    return this.secretSource!=null?this.secretSource.build():null;
    }
    public T withSecretSource( LocalObjectReference secretSource){
    if (secretSource!=null){ this.secretSource= new LocalObjectReferenceBuilder(secretSource); _visitables.add(this.secretSource);} return (T) this;
    }
    public SecretSourceNested<T> withNewSecretSource(){
    return new SecretSourceNestedImpl<T>();
    }
    public SecretSourceNested<T> withNewSecretSourceLike( LocalObjectReference item){
    return new SecretSourceNestedImpl<T>(item);
    }
    public SecretSourceNested<T> editSecretSource(){
    return withNewSecretSourceLike(getSecretSource());
    }
    public T withNewSecretSource( String name){
    return withSecretSource(new LocalObjectReference(name));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
SecretSpecFluentImpl that = (SecretSpecFluentImpl) o;
if (mountPath != null ? !mountPath.equals(that.mountPath) :that.mountPath != null) return false;
if (secretSource != null ? !secretSource.equals(that.secretSource) :that.secretSource != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class SecretSourceNestedImpl<N> extends LocalObjectReferenceFluentImpl<SecretSourceNested<N>> implements SecretSourceNested<N>{

        private final LocalObjectReferenceBuilder builder;
    
             SecretSourceNestedImpl (){
        this.builder = new LocalObjectReferenceBuilder(this);
        }
             SecretSourceNestedImpl ( LocalObjectReference item){
        this.builder = new LocalObjectReferenceBuilder(this, item);
        }
    
            public N endSecretSource(){
            return and();
        }
            public N and(){
            return (N) SecretSpecFluentImpl.this.withSecretSource(builder.build());
        }
    
}


}
