package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public interface CephFSVolumeSourceFluent<T extends CephFSVolumeSourceFluent<T>> extends Fluent<T>{


    public T addToMonitors( String ...items);    public T removeFromMonitors( String ...items);    public List<String> getMonitors();    public T withMonitors( List<String> monitors);    public T withMonitors( String ...monitors);    public String getPath();    public T withPath( String path);    public Boolean isReadOnly();    public T withReadOnly( Boolean readOnly);    public String getSecretFile();    public T withSecretFile( String secretFile);    public LocalObjectReference getSecretRef();    public T withSecretRef( LocalObjectReference secretRef);    public SecretRefNested<T> withNewSecretRef();    public SecretRefNested<T> withNewSecretRefLike( LocalObjectReference item);    public SecretRefNested<T> editSecretRef();    public T withNewSecretRef( String name);    public String getUser();    public T withUser( String user);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface SecretRefNested<N> extends Nested<N>, LocalObjectReferenceFluent<SecretRefNested<N>>{
            public N endSecretRef();            public N and();        
}


}
