package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class EventFluentImpl<T extends EventFluent<T>> extends BaseFluent<T> implements EventFluent<T>{

     String apiVersion;     Integer count;     String firstTimestamp;     VisitableBuilder<ObjectReference, ?> involvedObject;     String kind;     String lastTimestamp;     String message;     VisitableBuilder<ObjectMeta, ?> metadata;     String reason;     VisitableBuilder<EventSource, ?> source;     String type;     Map<String, Object> additionalProperties = new HashMap();
public EventFluentImpl(){
    
}
public EventFluentImpl( Event instance ){
    this.withApiVersion(instance.getApiVersion()); this.withCount(instance.getCount()); this.withFirstTimestamp(instance.getFirstTimestamp()); this.withInvolvedObject(instance.getInvolvedObject()); this.withKind(instance.getKind()); this.withLastTimestamp(instance.getLastTimestamp()); this.withMessage(instance.getMessage()); this.withMetadata(instance.getMetadata()); this.withReason(instance.getReason()); this.withSource(instance.getSource()); this.withType(instance.getType()); 
}

    public String getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public Integer getCount(){
    return this.count;
    }
    public T withCount( Integer count){
    this.count=count; return (T) this;
    }
    public String getFirstTimestamp(){
    return this.firstTimestamp;
    }
    public T withFirstTimestamp( String firstTimestamp){
    this.firstTimestamp=firstTimestamp; return (T) this;
    }
    public ObjectReference getInvolvedObject(){
    return this.involvedObject!=null?this.involvedObject.build():null;
    }
    public T withInvolvedObject( ObjectReference involvedObject){
    if (involvedObject!=null){ this.involvedObject= new ObjectReferenceBuilder(involvedObject); _visitables.add(this.involvedObject);} return (T) this;
    }
    public InvolvedObjectNested<T> withNewInvolvedObject(){
    return new InvolvedObjectNestedImpl<T>();
    }
    public InvolvedObjectNested<T> withNewInvolvedObjectLike( ObjectReference item){
    return new InvolvedObjectNestedImpl<T>(item);
    }
    public InvolvedObjectNested<T> editInvolvedObject(){
    return withNewInvolvedObjectLike(getInvolvedObject());
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public String getLastTimestamp(){
    return this.lastTimestamp;
    }
    public T withLastTimestamp( String lastTimestamp){
    this.lastTimestamp=lastTimestamp; return (T) this;
    }
    public String getMessage(){
    return this.message;
    }
    public T withMessage( String message){
    this.message=message; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNestedImpl<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public String getReason(){
    return this.reason;
    }
    public T withReason( String reason){
    this.reason=reason; return (T) this;
    }
    public EventSource getSource(){
    return this.source!=null?this.source.build():null;
    }
    public T withSource( EventSource source){
    if (source!=null){ this.source= new EventSourceBuilder(source); _visitables.add(this.source);} return (T) this;
    }
    public SourceNested<T> withNewSource(){
    return new SourceNestedImpl<T>();
    }
    public SourceNested<T> withNewSourceLike( EventSource item){
    return new SourceNestedImpl<T>(item);
    }
    public SourceNested<T> editSource(){
    return withNewSourceLike(getSource());
    }
    public T withNewSource( String component,  String host){
    return withSource(new EventSource(component, host));
    }
    public String getType(){
    return this.type;
    }
    public T withType( String type){
    this.type=type; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
EventFluentImpl that = (EventFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (count != null ? !count.equals(that.count) :that.count != null) return false;
if (firstTimestamp != null ? !firstTimestamp.equals(that.firstTimestamp) :that.firstTimestamp != null) return false;
if (involvedObject != null ? !involvedObject.equals(that.involvedObject) :that.involvedObject != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (lastTimestamp != null ? !lastTimestamp.equals(that.lastTimestamp) :that.lastTimestamp != null) return false;
if (message != null ? !message.equals(that.message) :that.message != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
if (source != null ? !source.equals(that.source) :that.source != null) return false;
if (type != null ? !type.equals(that.type) :that.type != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class InvolvedObjectNestedImpl<N> extends ObjectReferenceFluentImpl<InvolvedObjectNested<N>> implements InvolvedObjectNested<N>{

        private final ObjectReferenceBuilder builder;
    
             InvolvedObjectNestedImpl (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             InvolvedObjectNestedImpl ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N and(){
            return (N) EventFluentImpl.this.withInvolvedObject(builder.build());
        }
            public N endInvolvedObject(){
            return and();
        }
    
}
    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N and(){
            return (N) EventFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class SourceNestedImpl<N> extends EventSourceFluentImpl<SourceNested<N>> implements SourceNested<N>{

        private final EventSourceBuilder builder;
    
             SourceNestedImpl ( EventSource item){
        this.builder = new EventSourceBuilder(this, item);
        }
             SourceNestedImpl (){
        this.builder = new EventSourceBuilder(this);
        }
    
            public N and(){
            return (N) EventFluentImpl.this.withSource(builder.build());
        }
            public N endSource(){
            return and();
        }
    
}


}
