package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.List;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public interface ServiceAccountFluent<T extends ServiceAccountFluent<T>> extends Fluent<T>{


    public String getApiVersion();    public T withApiVersion( String apiVersion);    public T addToImagePullSecrets( LocalObjectReference ...items);    public T removeFromImagePullSecrets( LocalObjectReference ...items);    public List<LocalObjectReference> getImagePullSecrets();    public T withImagePullSecrets( List<LocalObjectReference> imagePullSecrets);    public T withImagePullSecrets( LocalObjectReference ...imagePullSecrets);    public ImagePullSecretsNested<T> addNewImagePullSecret();    public ImagePullSecretsNested<T> addNewImagePullSecretLike( LocalObjectReference item);    public T addNewImagePullSecret( String name);    public String getKind();    public T withKind( String kind);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public T addToSecrets( ObjectReference ...items);    public T removeFromSecrets( ObjectReference ...items);    public List<ObjectReference> getSecrets();    public T withSecrets( List<ObjectReference> secrets);    public T withSecrets( ObjectReference ...secrets);    public SecretsNested<T> addNewSecret();    public SecretsNested<T> addNewSecretLike( ObjectReference item);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface ImagePullSecretsNested<N> extends Nested<N>, LocalObjectReferenceFluent<ImagePullSecretsNested<N>>{
            public N and();            public N endImagePullSecret();        
}

    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface SecretsNested<N> extends Nested<N>, ObjectReferenceFluent<SecretsNested<N>>{
            public N and();            public N endSecret();        
}


}
