package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;

public class DeploymentSpecFluentImpl<T extends DeploymentSpecFluent<T>> extends BaseFluent<T> implements DeploymentSpecFluent<T>{

     Integer minReadySeconds;     Boolean paused;     Integer replicas;     Integer revisionHistoryLimit;     VisitableBuilder<RollbackConfig, ?> rollbackTo;     VisitableBuilder<LabelSelector, ?> selector;     VisitableBuilder<DeploymentStrategy, ?> strategy;     VisitableBuilder<PodTemplateSpec, ?> template;     Map<String, Object> additionalProperties = new HashMap();
public DeploymentSpecFluentImpl(){
    
}
public DeploymentSpecFluentImpl( DeploymentSpec instance ){
    this.withMinReadySeconds(instance.getMinReadySeconds()); this.withPaused(instance.getPaused()); this.withReplicas(instance.getReplicas()); this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit()); this.withRollbackTo(instance.getRollbackTo()); this.withSelector(instance.getSelector()); this.withStrategy(instance.getStrategy()); this.withTemplate(instance.getTemplate()); 
}

    public Integer getMinReadySeconds(){
    return this.minReadySeconds;
    }
    public T withMinReadySeconds( Integer minReadySeconds){
    this.minReadySeconds=minReadySeconds; return (T) this;
    }
    public Boolean isPaused(){
    return this.paused;
    }
    public T withPaused( Boolean paused){
    this.paused=paused; return (T) this;
    }
    public Integer getReplicas(){
    return this.replicas;
    }
    public T withReplicas( Integer replicas){
    this.replicas=replicas; return (T) this;
    }
    public Integer getRevisionHistoryLimit(){
    return this.revisionHistoryLimit;
    }
    public T withRevisionHistoryLimit( Integer revisionHistoryLimit){
    this.revisionHistoryLimit=revisionHistoryLimit; return (T) this;
    }
    public RollbackConfig getRollbackTo(){
    return this.rollbackTo!=null?this.rollbackTo.build():null;
    }
    public T withRollbackTo( RollbackConfig rollbackTo){
    if (rollbackTo!=null){ this.rollbackTo= new RollbackConfigBuilder(rollbackTo); _visitables.add(this.rollbackTo);} return (T) this;
    }
    public RollbackToNested<T> withNewRollbackTo(){
    return new RollbackToNestedImpl<T>();
    }
    public RollbackToNested<T> withNewRollbackToLike( RollbackConfig item){
    return new RollbackToNestedImpl<T>(item);
    }
    public RollbackToNested<T> editRollbackTo(){
    return withNewRollbackToLike(getRollbackTo());
    }
    public T withNewRollbackTo( Long revision){
    return withRollbackTo(new RollbackConfig(revision));
    }
    public LabelSelector getSelector(){
    return this.selector!=null?this.selector.build():null;
    }
    public T withSelector( LabelSelector selector){
    if (selector!=null){ this.selector= new LabelSelectorBuilder(selector); _visitables.add(this.selector);} return (T) this;
    }
    public SelectorNested<T> withNewSelector(){
    return new SelectorNestedImpl<T>();
    }
    public SelectorNested<T> withNewSelectorLike( LabelSelector item){
    return new SelectorNestedImpl<T>(item);
    }
    public SelectorNested<T> editSelector(){
    return withNewSelectorLike(getSelector());
    }
    public DeploymentStrategy getStrategy(){
    return this.strategy!=null?this.strategy.build():null;
    }
    public T withStrategy( DeploymentStrategy strategy){
    if (strategy!=null){ this.strategy= new DeploymentStrategyBuilder(strategy); _visitables.add(this.strategy);} return (T) this;
    }
    public StrategyNested<T> withNewStrategy(){
    return new StrategyNestedImpl<T>();
    }
    public StrategyNested<T> withNewStrategyLike( DeploymentStrategy item){
    return new StrategyNestedImpl<T>(item);
    }
    public StrategyNested<T> editStrategy(){
    return withNewStrategyLike(getStrategy());
    }
    public PodTemplateSpec getTemplate(){
    return this.template!=null?this.template.build():null;
    }
    public T withTemplate( PodTemplateSpec template){
    if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.add(this.template);} return (T) this;
    }
    public TemplateNested<T> withNewTemplate(){
    return new TemplateNestedImpl<T>();
    }
    public TemplateNested<T> withNewTemplateLike( PodTemplateSpec item){
    return new TemplateNestedImpl<T>(item);
    }
    public TemplateNested<T> editTemplate(){
    return withNewTemplateLike(getTemplate());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
DeploymentSpecFluentImpl that = (DeploymentSpecFluentImpl) o;
if (minReadySeconds != null ? !minReadySeconds.equals(that.minReadySeconds) :that.minReadySeconds != null) return false;
if (paused != null ? !paused.equals(that.paused) :that.paused != null) return false;
if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
if (revisionHistoryLimit != null ? !revisionHistoryLimit.equals(that.revisionHistoryLimit) :that.revisionHistoryLimit != null) return false;
if (rollbackTo != null ? !rollbackTo.equals(that.rollbackTo) :that.rollbackTo != null) return false;
if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
if (strategy != null ? !strategy.equals(that.strategy) :that.strategy != null) return false;
if (template != null ? !template.equals(that.template) :that.template != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class RollbackToNestedImpl<N> extends RollbackConfigFluentImpl<RollbackToNested<N>> implements RollbackToNested<N>{

        private final RollbackConfigBuilder builder;
    
             RollbackToNestedImpl (){
        this.builder = new RollbackConfigBuilder(this);
        }
             RollbackToNestedImpl ( RollbackConfig item){
        this.builder = new RollbackConfigBuilder(this, item);
        }
    
            public N endRollbackTo(){
            return and();
        }
            public N and(){
            return (N) DeploymentSpecFluentImpl.this.withRollbackTo(builder.build());
        }
    
}
    public class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<SelectorNested<N>> implements SelectorNested<N>{

        private final LabelSelectorBuilder builder;
    
             SelectorNestedImpl (){
        this.builder = new LabelSelectorBuilder(this);
        }
             SelectorNestedImpl ( LabelSelector item){
        this.builder = new LabelSelectorBuilder(this, item);
        }
    
            public N endSelector(){
            return and();
        }
            public N and(){
            return (N) DeploymentSpecFluentImpl.this.withSelector(builder.build());
        }
    
}
    public class StrategyNestedImpl<N> extends DeploymentStrategyFluentImpl<StrategyNested<N>> implements StrategyNested<N>{

        private final DeploymentStrategyBuilder builder;
    
             StrategyNestedImpl (){
        this.builder = new DeploymentStrategyBuilder(this);
        }
             StrategyNestedImpl ( DeploymentStrategy item){
        this.builder = new DeploymentStrategyBuilder(this, item);
        }
    
            public N endStrategy(){
            return and();
        }
            public N and(){
            return (N) DeploymentSpecFluentImpl.this.withStrategy(builder.build());
        }
    
}
    public class TemplateNestedImpl<N> extends PodTemplateSpecFluentImpl<TemplateNested<N>> implements TemplateNested<N>{

        private final PodTemplateSpecBuilder builder;
    
             TemplateNestedImpl (){
        this.builder = new PodTemplateSpecBuilder(this);
        }
             TemplateNestedImpl ( PodTemplateSpec item){
        this.builder = new PodTemplateSpecBuilder(this, item);
        }
    
            public N endTemplate(){
            return and();
        }
            public N and(){
            return (N) DeploymentSpecFluentImpl.this.withTemplate(builder.build());
        }
    
}


}
