package io.fabric8.kubernetes.api.model.extensions;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.List;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import java.util.List;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class HTTPIngressRuleValueFluentImpl<T extends HTTPIngressRuleValueFluent<T>> extends BaseFluent<T> implements HTTPIngressRuleValueFluent<T>{

     List<VisitableBuilder<HTTPIngressPath, ?>> paths = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();
public HTTPIngressRuleValueFluentImpl(){
    
}
public HTTPIngressRuleValueFluentImpl( HTTPIngressRuleValue instance ){
    this.withPaths(instance.getPaths()); 
}

    public T addToPaths( HTTPIngressPath ...items){
    for (HTTPIngressPath item : items) {HTTPIngressPathBuilder builder = new HTTPIngressPathBuilder(item);_visitables.add(builder);this.paths.add(builder);} return (T)this;
    }
    public T removeFromPaths( HTTPIngressPath ...items){
    for (HTTPIngressPath item : items) {HTTPIngressPathBuilder builder = new HTTPIngressPathBuilder(item);_visitables.remove(builder);this.paths.remove(builder);} return (T)this;
    }
    public List<HTTPIngressPath> getPaths(){
    return build(paths);
    }
    public T withPaths( List<HTTPIngressPath> paths){
    this.paths.clear();if (paths != null) {for (HTTPIngressPath item : paths){this.addToPaths(item);}} return (T) this;
    }
    public T withPaths( HTTPIngressPath ...paths){
    this.paths.clear(); if (paths != null) {for (HTTPIngressPath item :paths){ this.addToPaths(item);}} return (T) this;
    }
    public PathsNested<T> addNewPath(){
    return new PathsNestedImpl<T>();
    }
    public PathsNested<T> addNewPathLike( HTTPIngressPath item){
    return new PathsNestedImpl<T>(item);
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
HTTPIngressRuleValueFluentImpl that = (HTTPIngressRuleValueFluentImpl) o;
if (paths != null ? !paths.equals(that.paths) :that.paths != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class PathsNestedImpl<N> extends HTTPIngressPathFluentImpl<PathsNested<N>> implements PathsNested<N>{

        private final HTTPIngressPathBuilder builder;
    
             PathsNestedImpl (){
        this.builder = new HTTPIngressPathBuilder(this);
        }
             PathsNestedImpl ( HTTPIngressPath item){
        this.builder = new HTTPIngressPathBuilder(this, item);
        }
    
            public N and(){
            return (N) HTTPIngressRuleValueFluentImpl.this.addToPaths(builder.build());
        }
            public N endPath(){
            return and();
        }
    
}


}
