package io.fabric8.kubernetes.api.model.extensions;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class HorizontalPodAutoscalerStatusFluentImpl<T extends HorizontalPodAutoscalerStatusFluent<T>> extends BaseFluent<T> implements HorizontalPodAutoscalerStatusFluent<T>{

     Integer currentCPUUtilizationPercentage;     Integer currentReplicas;     Integer desiredReplicas;     String lastScaleTime;     Long observedGeneration;     Map<String, Object> additionalProperties = new HashMap();
public HorizontalPodAutoscalerStatusFluentImpl(){
    
}
public HorizontalPodAutoscalerStatusFluentImpl( HorizontalPodAutoscalerStatus instance ){
    this.withCurrentCPUUtilizationPercentage(instance.getCurrentCPUUtilizationPercentage()); this.withCurrentReplicas(instance.getCurrentReplicas()); this.withDesiredReplicas(instance.getDesiredReplicas()); this.withLastScaleTime(instance.getLastScaleTime()); this.withObservedGeneration(instance.getObservedGeneration()); 
}

    public Integer getCurrentCPUUtilizationPercentage(){
    return this.currentCPUUtilizationPercentage;
    }
    public T withCurrentCPUUtilizationPercentage( Integer currentCPUUtilizationPercentage){
    this.currentCPUUtilizationPercentage=currentCPUUtilizationPercentage; return (T) this;
    }
    public Integer getCurrentReplicas(){
    return this.currentReplicas;
    }
    public T withCurrentReplicas( Integer currentReplicas){
    this.currentReplicas=currentReplicas; return (T) this;
    }
    public Integer getDesiredReplicas(){
    return this.desiredReplicas;
    }
    public T withDesiredReplicas( Integer desiredReplicas){
    this.desiredReplicas=desiredReplicas; return (T) this;
    }
    public String getLastScaleTime(){
    return this.lastScaleTime;
    }
    public T withLastScaleTime( String lastScaleTime){
    this.lastScaleTime=lastScaleTime; return (T) this;
    }
    public Long getObservedGeneration(){
    return this.observedGeneration;
    }
    public T withObservedGeneration( Long observedGeneration){
    this.observedGeneration=observedGeneration; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
HorizontalPodAutoscalerStatusFluentImpl that = (HorizontalPodAutoscalerStatusFluentImpl) o;
if (currentCPUUtilizationPercentage != null ? !currentCPUUtilizationPercentage.equals(that.currentCPUUtilizationPercentage) :that.currentCPUUtilizationPercentage != null) return false;
if (currentReplicas != null ? !currentReplicas.equals(that.currentReplicas) :that.currentReplicas != null) return false;
if (desiredReplicas != null ? !desiredReplicas.equals(that.desiredReplicas) :that.desiredReplicas != null) return false;
if (lastScaleTime != null ? !lastScaleTime.equals(that.lastScaleTime) :that.lastScaleTime != null) return false;
if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
